/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.ml.math;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.impls.matrix.SparseDistributedMatrix;
import org.apache.ignite.yardstick.ml.math.IgniteAbstractMatrixMulBenchmark;

public class IgniteSparseDistributedMatrixMulBenchmark
extends IgniteAbstractMatrixMulBenchmark {
    private static final int SCALE_DOWN = 2;

    @Override
    Matrix newMatrix(int rowSize, int colSize) {
        return new SparseDistributedMatrix(rowSize >> 2, colSize >> 2, 2001, 1002);
    }

    @Override
    Matrix createAndFill(double[][] data, double scale) {
        Matrix res = this.newMatrix(data.length, data[0].length);
        for (int row = 0; row < res.rowSize(); ++row) {
            for (int col = 0; col < res.columnSize(); ++col) {
                res.set(row, col, row == col ? data[row][col] * scale : data[row][col]);
            }
        }
        return res;
    }
}

