/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.ml.math;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.ml.DataChanger;

abstract class IgniteAbstractMatrixMulBenchmark
extends IgniteAbstractBenchmark {
    private static final int SIZE = 128;
    private double[][] dataSquare = this.createAndFill(128, 128);
    private double[][] dataRect1 = this.createAndFill(64, 128);
    private double[][] dataRect2 = this.createAndFill(128, 64);
    @IgniteInstanceResource
    private Ignite ignite;

    IgniteAbstractMatrixMulBenchmark() {
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        final double scale = DataChanger.next();
        IgniteThread igniteThread = new IgniteThread(this.ignite.configuration().getIgniteInstanceName(), ((Object)((Object)this)).getClass().getSimpleName(), new Runnable(){

            @Override
            public void run() {
                Matrix m1 = IgniteAbstractMatrixMulBenchmark.this.createAndFill(IgniteAbstractMatrixMulBenchmark.this.dataSquare, scale);
                Matrix m2 = IgniteAbstractMatrixMulBenchmark.this.createAndFill(IgniteAbstractMatrixMulBenchmark.this.dataSquare, scale);
                Matrix m7 = IgniteAbstractMatrixMulBenchmark.this.times(m1, m2);
                Matrix m3 = IgniteAbstractMatrixMulBenchmark.this.createAndFill(IgniteAbstractMatrixMulBenchmark.this.dataRect1, scale);
                Matrix m4 = IgniteAbstractMatrixMulBenchmark.this.createAndFill(IgniteAbstractMatrixMulBenchmark.this.dataRect2, scale);
                Matrix m8 = IgniteAbstractMatrixMulBenchmark.this.times(m3, m4);
                Matrix m5 = IgniteAbstractMatrixMulBenchmark.this.createAndFill(IgniteAbstractMatrixMulBenchmark.this.dataRect2, scale);
                Matrix m6 = IgniteAbstractMatrixMulBenchmark.this.createAndFill(IgniteAbstractMatrixMulBenchmark.this.dataRect1, scale);
                Matrix m9 = IgniteAbstractMatrixMulBenchmark.this.times(m5, m6);
                m1.destroy();
                m2.destroy();
                m3.destroy();
                m4.destroy();
                m5.destroy();
                m6.destroy();
                m7.destroy();
                m8.destroy();
                m9.destroy();
            }
        });
        igniteThread.start();
        igniteThread.join();
        return true;
    }

    abstract Matrix newMatrix(int var1, int var2);

    Matrix times(Matrix m1, Matrix m2) {
        return m1.times(m2);
    }

    Matrix createAndFill(double[][] data, double scale) {
        Matrix res = this.newMatrix(data.length, data[0].length).assign(data);
        for (int i = 0; i < data.length && i < data[0].length; ++i) {
            res.set(i, i, data[i][i] * scale);
        }
        return res;
    }

    private double[][] createAndFill(int rowSize, int colSize) {
        double[][] data = new double[rowSize][colSize];
        for (int i = 0; i < rowSize; ++i) {
            for (int j = 0; j < colSize; ++j) {
                data[i][j] = -0.5 + Math.random();
            }
        }
        return data;
    }
}

