/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.yardstick.jdbc.AbstractNativeBenchmark;

public class NativeSqlQueryRangeBenchmark
extends AbstractNativeBenchmark {
    public boolean test(Map<Object, Object> ctx) throws Exception {
        long expRsSize;
        SqlFieldsQuery qry;
        if (this.args.sqlRange() == 1) {
            qry = new SqlFieldsQuery("SELECT id, val FROM test_long WHERE id = ?");
            qry.setArgs(new Object[]{ThreadLocalRandom.current().nextLong(this.args.range()) + 1L});
            expRsSize = 1L;
        } else {
            qry = new SqlFieldsQuery("SELECT id, val FROM test_long WHERE id BETWEEN ? AND ?");
            long id = ThreadLocalRandom.current().nextLong(this.args.range() - this.args.sqlRange()) + 1L;
            long maxId = id + (long)this.args.sqlRange() - 1L;
            qry.setArgs(new Object[]{id, maxId});
            expRsSize = this.args.sqlRange();
        }
        long rsSize = 0L;
        try (FieldsQueryCursor cursor = ((IgniteEx)this.ignite()).context().query().querySqlFields(qry, false);){
            for (List row : cursor) {
                if ((Long)row.get(0) + 1L != (Long)row.get(1)) {
                    throw new Exception("Invalid result retrieved");
                }
                ++rsSize;
            }
        }
        if (rsSize != expRsSize) {
            throw new Exception("Invalid result set size [actual=" + rsSize + ", expected=" + expRsSize + ']');
        }
        return true;
    }
}

