/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.yardstick.cache.jdbc.JdbcAbstractBenchmark;

public class JdbcPutBenchmark
extends JdbcAbstractBenchmark {
    public boolean test(Map<Object, Object> ctx) throws Exception {
        int newKey = JdbcPutBenchmark.nextRandom(this.args.range());
        int newVal = JdbcPutBenchmark.nextRandom(this.args.range());
        try (PreparedStatement stmt = JdbcPutBenchmark.createUpsertStatement((Connection)this.conn.get(), newKey, newVal);){
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.args.createTempDatabase()) {
            this.clearTable("SAMPLE");
        }
        super.tearDown();
    }

    static PreparedStatement createUpsertStatement(Connection conn, int newKey, int newVal) throws SQLException {
        PreparedStatement stmt;
        switch (conn.getMetaData().getDatabaseProductName()) {
            case "H2": {
                stmt = conn.prepareStatement("merge into SAMPLE(id, val) values(?, ?)");
                break;
            }
            case "MySQL": {
                stmt = conn.prepareStatement("insert into SAMPLE(id, val) values(?, ?) on duplicate key update val = ?");
                stmt.setInt(3, newVal);
                break;
            }
            case "PostgreSQL": {
                stmt = conn.prepareStatement("insert into SAMPLE(id, val) values(?, ?) on conflict(id) do update set val = ?");
                stmt.setInt(3, newVal);
                break;
            }
            default: {
                throw new IgniteException("Unexpected database type [databaseProductName=" + conn.getMetaData().getDatabaseProductName() + ']');
            }
        }
        stmt.setInt(1, newKey);
        stmt.setInt(2, newVal);
        return stmt;
    }
}

