/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.failover;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.cache.failover.IgniteConsistencyException;
import org.apache.ignite.yardstick.cache.failover.IgniteFailoverAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteTransactionalWriteInvokeBenchmark
extends IgniteFailoverAbstractBenchmark<String, Long> {
    private static final Long INITIAL_VALUE = 1L;
    public static final int TIMEOUT_SEC = 1200;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        assert (this.args.keysCount() > 0) : "Count of keys: " + this.args.keysCount();
        IgniteCountDownLatch latch = this.ignite().countDownLatch("DATA-POPULATED-LATCH-" + this.cacheName(), 1, true, true);
        if (cfg.memberId() == 0) {
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populating data for cache: " + this.cacheName()));
            long start = System.nanoTime();
            try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(this.cacheName());){
                for (int k = 0; k < this.args.range() && !Thread.currentThread().isInterrupted(); ++k) {
                    dataLdr.addData((Object)("key-" + k + "-master"), (Object)INITIAL_VALUE);
                    for (int i = 0; i < this.args.keysCount(); ++i) {
                        dataLdr.addData((Object)("key-" + k + "-" + i), (Object)INITIAL_VALUE);
                    }
                    if (k % 100000 != 0) continue;
                    BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populated accounts: " + k));
                }
            }
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Finished populating data in " + (System.nanoTime() - start) / 1000000L + " ms. for cache: " + this.cacheName()));
            latch.countDown();
        } else {
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Waiting for populating data in cache by driver with id 0: " + this.cacheName()));
            boolean success = latch.await(1200L, TimeUnit.SECONDS);
            if (!success) {
                throw new IllegalStateException("Failed to wait that data populating finish.");
            }
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Finished waiting for populating data in cache by driver with id 0: " + this.cacheName()));
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        int k = IgniteTransactionalWriteInvokeBenchmark.nextRandom(this.args.range());
        final String[] keys = new String[this.args.keysCount()];
        final String masterKey = "key-" + k + "-master";
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = "key-" + k + "-" + i;
        }
        final int scenario = IgniteTransactionalWriteInvokeBenchmark.nextRandom(2);
        final LinkedHashSet badKeys = new LinkedHashSet();
        IgniteBenchmarkUtils.doInTransaction(this.ignite().transactions(), TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int timeout = IgniteTransactionalWriteInvokeBenchmark.this.args.cacheOperationTimeoutMillis();
                switch (scenario) {
                    case 0: {
                        HashMap<String, Long> map = new HashMap<String, Long>();
                        Long cacheVal = (Long)IgniteTransactionalWriteInvokeBenchmark.this.cache.getAsync((Object)masterKey).get((long)timeout);
                        map.put(masterKey, cacheVal);
                        for (String key : keys) {
                            cacheVal = (Long)IgniteTransactionalWriteInvokeBenchmark.this.cache.getAsync((Object)key).get((long)timeout);
                            map.put(key, cacheVal);
                        }
                        HashSet values = new HashSet(map.values());
                        if (values.size() == 1) break;
                        throw new IgniteConsistencyException("Found different values for keys [map=" + map + "]");
                    }
                    case 1: {
                        Long val = (Long)IgniteTransactionalWriteInvokeBenchmark.this.cache.getAsync((Object)masterKey).get((long)timeout);
                        if (val == null) {
                            badKeys.add(masterKey);
                        }
                        IgniteTransactionalWriteInvokeBenchmark.this.cache.putAsync((Object)masterKey, (Object)(val == null ? -1L : val + 1L)).get((long)timeout);
                        for (String key : keys) {
                            Object o = IgniteTransactionalWriteInvokeBenchmark.this.cache.invokeAsync((Object)key, (CacheEntryProcessor)new IncrementWriteInvokeCacheEntryProcessor(), new Object[]{IgniteTransactionalWriteInvokeBenchmark.this.cacheName()}).get((long)timeout);
                            if (o == null) continue;
                            badKeys.add(key);
                        }
                        break;
                    }
                }
                return null;
            }
        });
        if (!F.isEmpty(badKeys)) {
            throw new IgniteConsistencyException("Found unexpected null-value(s) for the following key(s) (look for debug information on server nodes): " + badKeys);
        }
        return true;
    }

    @Override
    protected String cacheName() {
        return "tx-write-invoke";
    }

    private static class IncrementWriteInvokeCacheEntryProcessor
    implements CacheEntryProcessor<String, Long, Object> {
        private static final long serialVersionUID = 0L;

        private IncrementWriteInvokeCacheEntryProcessor() {
        }

        public Object process(MutableEntry<String, Long> entry, Object ... arguments) throws EntryProcessorException {
            if (entry.getValue() == null) {
                String cacheName = (String)arguments[0];
                IgniteKernal kernal = (IgniteKernal)entry.unwrap(Ignite.class);
                Affinity aff = kernal.affinity(cacheName);
                int partIdx = aff.partition(entry.getKey());
                Collection nodes = aff.mapKeyToPrimaryAndBackups(entry.getKey());
                List locPartitions = kernal.cachex(cacheName).context().topology().localPartitions();
                GridDhtLocalPartition part = null;
                for (GridDhtLocalPartition p : locPartitions) {
                    if (p.id() != partIdx) continue;
                    part = p;
                    break;
                }
                kernal.log().warning("Found unexpected null-value, debug info:\n    entry=" + entry + "\n    key=" + (String)entry.getKey() + "\n    locNodeId=" + kernal.cluster().localNode().id() + "\n    primaryAndBackupsNodes=" + nodes + "\n    part=" + part + "\n    partIdx=" + partIdx + "\n    locParts=" + locPartitions + "\n    allPartMap=" + kernal.cachex(cacheName).context().topology().partitionMap(true));
                return new Object();
            }
            entry.setValue((Object)((Long)entry.getValue() + 1L));
            return null;
        }
    }
}

