/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Organization;
import org.apache.ignite.yardstick.cache.model.Person;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlQueryJoinBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating query data...");
        this.loadCachesData();
    }

    @Override
    protected void loadCacheData(String cacheName) {
        if (this.args.range() < 100) {
            throw new IllegalArgumentException("Invalid range: " + this.args.range());
        }
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(cacheName);){
            int i;
            int orgRange = this.args.range() / 10;
            for (i = 0; i < orgRange && !Thread.currentThread().isInterrupted(); ++i) {
                dataLdr.addData((Object)i, (Object)new Organization(i, "org" + i));
            }
            dataLdr.flush();
            for (i = orgRange; i < orgRange + this.args.range() && !Thread.currentThread().isInterrupted(); ++i) {
                Person p = new Person(i, IgniteSqlQueryJoinBenchmark.nextRandom(orgRange), "firstName" + i, "lastName" + i, (i - orgRange) * 1000);
                dataLdr.addData((Object)i, (Object)p);
                if (i % 100000 != 0) continue;
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Populated persons: " + i));
            }
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        double salary = ThreadLocalRandom.current().nextDouble() * (double)this.args.range() * 1000.0;
        double maxSalary = salary + 1000.0;
        Collection<List<?>> lists = this.executeQueryJoin(salary, maxSalary);
        for (List<?> l : lists) {
            double sal = (Double)l.get(4);
            if (!(sal < salary) && !(sal > maxSalary)) continue;
            Person p = new Person();
            p.setId((Integer)l.get(0));
            p.setOrganizationId((Integer)l.get(1));
            p.setFirstName((String)l.get(2));
            p.setLastName((String)l.get(3));
            p.setSalary(sal);
            throw new Exception("Invalid person retrieved [min=" + salary + ", max=" + maxSalary + ", person=" + p + ']');
        }
        return true;
    }

    private Collection<List<?>> executeQueryJoin(double minSalary, double maxSalary) throws Exception {
        IgniteCache cache = this.cacheForOperation(true);
        SqlFieldsQuery qry = new SqlFieldsQuery("select p.id, p.orgId, p.firstName, p.lastName, p.salary, o.name from Person p left join Organization o on p.id = o.id where salary >= ? and salary <= ?");
        qry.setArgs(new Object[]{minSalary, maxSalary});
        return cache.query(qry).getAll();
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }
}

