/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.yardstick.upload.UploadBenchmarkArguments;
import org.jetbrains.annotations.Nullable;

public class IgniteBenchmarkArguments {
    @Parameter(names={"-nn", "--nodeNumber"}, description="Node number")
    private int nodes = 1;
    @Parameter(names={"-b", "--backups"}, description="Backups")
    private int backups;
    @Parameter(names={"-cfg", "--Config"}, description="Configuration file")
    private String cfg = "config/ignite-localhost-config.xml";
    @Parameter(names={"-ltqf", "--loadTestQueriesFile"}, description="File with predefined SQL queries")
    private String loadTestQueriesFile = null;
    @Parameter(names={"-sm", "--syncMode"}, description="Synchronization mode")
    private CacheWriteSynchronizationMode syncMode = CacheWriteSynchronizationMode.PRIMARY_SYNC;
    @Parameter(names={"-cl", "--client"}, description="Client flag")
    private boolean clientOnly = false;
    @Parameter(names={"-nc", "--nearCache"}, description="Near cache flag")
    private boolean nearCacheFlag = false;
    @Parameter(names={"-ncs", "--nearCacheSize"}, description="Near cache size")
    private int nearCacheSize;
    @Parameter(names={"-txc", "--txConcurrency"}, description="Transaction concurrency")
    private TransactionConcurrency txConcurrency = TransactionConcurrency.PESSIMISTIC;
    @Parameter(names={"-txi", "--txIsolation"}, description="Transaction isolation")
    private TransactionIsolation txIsolation = TransactionIsolation.REPEATABLE_READ;
    @Parameter(names={"-rtp", "--restPort"}, description="REST TCP port")
    private int restTcpPort;
    @Parameter(names={"-rth", "--restHost"}, description="REST TCP host")
    private String restTcpHost;
    @Parameter(names={"-r", "--range"}, description="Key range")
    @GridToStringInclude
    private int range = 1000000;
    @Parameter(names={"-sf", "--scaleFactor"}, description="Scale factor")
    private int scaleFactor = 1;
    @Parameter(names={"-ntv", "--native"}, description="Native benchmarking flag")
    private boolean ntv = false;
    @Parameter(names={"-pa", "--preloadAmount"}, description="Data pre-loading amount for load tests")
    private int preloadAmount = 500000;
    @Parameter(names={"-plfreq", "--preloadLogFrequency"}, description="Interval between printing logs")
    private long preloadLogsInterval = 30000L;
    @Parameter(names={"-j", "--jobs"}, description="Number of jobs for compute benchmarks")
    private int jobs = 10;
    @Parameter(names={"-cs", "--cacheStore"}, description="Enable or disable cache store readThrough, writeThrough")
    private boolean storeEnabled;
    @Parameter(names={"-cwd", "--cleanWorkDirectory"}, description="Clean Work Directory")
    private boolean cleanWorkDirectory = false;
    @Parameter(names={"-wb", "--writeBehind"}, description="Enable or disable writeBehind for cache store")
    private boolean writeBehind;
    @Parameter(names={"-bs", "--batchSize"}, description="Batch size")
    private int batch = 500;
    @Parameter(names={"-col", "--collocated"}, description="Collocated")
    private boolean collocated;
    @Parameter(names={"-stripe", "--singleStripe"}, description="Generate keys belonging to single stripe per node")
    private boolean singleStripe;
    @Parameter(names={"-jdbc", "--jdbcUrl"}, description="JDBC url")
    private String jdbcUrl;
    @Parameter(names={"-sch", "--schema"}, description="File with SQL schema definition")
    private String schemaDefinition = null;
    @Parameter(names={"-jdbcDrv", "--jdbcDriver"}, description="FQN of driver class for JDBC native benchmarks (must be on classpath)")
    private String jdbcDriver = null;
    @Parameter(names={"-tempDb", "--temporaryDatabase"}, description="Whether it's needed to create and drop temporary database for JDBC benchmarks dummy data")
    private boolean createTempDatabase = false;
    @Parameter(names={"-dbn", "--databaseName"}, description="Name of database")
    private String dbn = null;
    @Parameter(names={"-rd", "--restartdelay"}, description="Restart delay in seconds")
    private int restartDelay = 20;
    @Parameter(names={"-rs", "--restartsleep"}, description="Restart sleep in seconds")
    private int restartSleep = 2;
    @Parameter(names={"-checkingPeriod", "--checkingPeriod"}, description="Period to check cache consistency in seconds")
    private int cacheConsistencyCheckingPeriod = 120;
    @Parameter(names={"-kc", "--keysCount"}, description="Count of keys")
    private int keysCnt = 5;
    @Parameter(names={"-cot", "--cacheOperationTimeout"}, description="Max timeout for cache operations in seconds")
    private int cacheOpTimeout = 30;
    @Parameter(names={"-kpt", "--keysPerThread"}, description="Use not intersecting keys in putAll benchmark")
    private boolean keysPerThread;
    @Parameter(names={"-pc", "--partitionedCachesNumber"}, description="Number of partitioned caches")
    private int partitionedCachesNumber = 1;
    @Parameter(names={"-rc", "--replicatedCachesNumber"}, description="Number of replicated caches")
    private int replicatedCachesNumber = 1;
    @Parameter(names={"-ac", "--additionalCachesNumber"}, description="Number of additional caches")
    private int additionalCachesNum;
    @Parameter(names={"-acn", "--additionalCachesName"}, description="Template cache name for additional caches")
    private String additionalCachesName;
    @Parameter(names={"-pp", "--printPartitionStats"}, description="Print partition statistics")
    private boolean printPartStats;
    @Parameter(names={"-ltops", "--allowedLoadTestOperations"}, variableArity=true, description="List of enabled load test operations")
    private List<String> allowedLoadTestOps = new ArrayList<String>();
    @Parameter(names={"-ps", "--pageSize"}, description="Page size")
    private int pageSize = 4096;
    @Parameter(names={"-sl", "--stringLength"}, description="Test string length")
    private int stringLength = 500;
    @Parameter(names={"-wt", "--warningTime"}, description="Warning time interval for printing log")
    private long warningTime = 500L;
    @Parameter(names={"-prb", "--printRollBacks"}, description="Print rollBacks")
    private boolean printRollBacks;
    @Parameter(names={"-prt", "--partitions"}, description="Number of cache partitions")
    private int partitions = 10;
    @Parameter(names={"-cg", "--cacheGrp"}, description="Cache group for caches")
    private String cacheGrp;
    @Parameter(names={"-cc", "--cachesCnt"}, description="Number of caches to create")
    private int cachesCnt = 1;
    @Parameter(names={"-pds", "--persistentStore"}, description="Persistent store flag")
    private boolean persistentStoreEnabled;
    @Parameter(names={"-stcp", "--streamerCachesPrefix"}, description="Cache name prefix for streamer benchmark")
    private String streamerCachesPrefix = "streamer";
    @Parameter(names={"-stci", "--streamerCachesIndex"}, description="First cache index for streamer benchmark")
    private int streamerCacheIndex;
    @Parameter(names={"-stcc", "--streamerConcCaches"}, description="Number of concurrently loaded caches for streamer benchmark")
    private int streamerConcurrentCaches = 1;
    @Parameter(names={"-stbs", "--streamerBufSize"}, description="Data streamer buffer size")
    private int streamerBufSize = 512;
    @Parameter(names={"-sqlr", "--sqlRange"}, description="Result set size")
    @GridToStringInclude
    private int sqlRange = 1;
    @Parameter(names={"-clidx", "--clientNodesAfterId"}, description="Start client nodes when server ID greater then the parameter value")
    @GridToStringInclude
    private int clientNodesAfterId = -1;
    @ParametersDelegate
    @GridToStringInclude
    public UploadBenchmarkArguments upload = new UploadBenchmarkArguments();

    public boolean persistentStoreEnabled() {
        return this.persistentStoreEnabled;
    }

    public List<String> allowedLoadTestOps() {
        return this.allowedLoadTestOps;
    }

    public boolean printPartitionStatistics() {
        return this.printPartStats;
    }

    public String jdbcUrl() {
        return this.jdbcUrl;
    }

    public String jdbcDriver() {
        return this.jdbcDriver;
    }

    public String schemaDefinition() {
        return this.schemaDefinition;
    }

    public boolean createTempDatabase() {
        return this.createTempDatabase;
    }

    public String dbn() {
        return this.dbn;
    }

    public TransactionConcurrency txConcurrency() {
        return this.txConcurrency;
    }

    public TransactionIsolation txIsolation() {
        return this.txIsolation;
    }

    public int restTcpPort() {
        return this.restTcpPort;
    }

    public String restTcpHost() {
        return this.restTcpHost;
    }

    public boolean isClientOnly() {
        return this.clientOnly;
    }

    public boolean isNearCache() {
        return this.nearCacheFlag;
    }

    public int getNearCacheSize() {
        return this.nearCacheSize;
    }

    public CacheWriteSynchronizationMode syncMode() {
        return this.syncMode;
    }

    public int backups() {
        return this.backups;
    }

    public boolean isNative() {
        return this.ntv;
    }

    public int nodes() {
        return this.nodes;
    }

    public int range() {
        return this.range;
    }

    public int scaleFactor() {
        return this.scaleFactor;
    }

    public int preloadAmount() {
        return this.preloadAmount;
    }

    public long preloadLogsInterval() {
        return this.preloadLogsInterval;
    }

    public String configuration() {
        return this.cfg;
    }

    public String loadTestQueriesFile() {
        return this.loadTestQueriesFile;
    }

    public int jobs() {
        return this.jobs;
    }

    public boolean isStoreEnabled() {
        return this.storeEnabled;
    }

    public boolean isWriteBehind() {
        return this.writeBehind;
    }

    public int batch() {
        return this.batch;
    }

    public boolean collocated() {
        return this.collocated;
    }

    public boolean singleStripe() {
        return this.singleStripe;
    }

    public int restartDelay() {
        return this.restartDelay;
    }

    public int restartSleep() {
        return this.restartSleep;
    }

    public int keysCount() {
        return this.keysCnt;
    }

    public int cacheConsistencyCheckingPeriod() {
        return this.cacheConsistencyCheckingPeriod;
    }

    public int cacheOperationTimeoutMillis() {
        return this.cacheOpTimeout * 1000;
    }

    public boolean keysPerThread() {
        return this.keysPerThread;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public long getWarningTime() {
        return this.warningTime;
    }

    public boolean printRollBacks() {
        return this.printRollBacks;
    }

    public int partitionedCachesNumber() {
        return this.partitionedCachesNumber;
    }

    public int replicatedCachesNumber() {
        return this.replicatedCachesNumber;
    }

    public int partitions() {
        return this.partitions;
    }

    public int additionalCachesNumber() {
        return this.additionalCachesNum;
    }

    public String additionalCachesName() {
        return this.additionalCachesName;
    }

    public boolean cleanWorkDirectory() {
        return this.cleanWorkDirectory;
    }

    @Nullable
    public String cacheGroup() {
        return this.cacheGrp;
    }

    public int cachesCount() {
        return this.cachesCnt;
    }

    public String description() {
        return "-nn=" + this.nodes + "-b=" + this.backups + "-sm=" + this.syncMode + "-cl=" + this.clientOnly + "-nc=" + this.nearCacheFlag + "-txc=" + this.txConcurrency + "-rd=" + this.restartDelay + "-rs=" + this.restartSleep;
    }

    public String streamerCachesPrefix() {
        return this.streamerCachesPrefix;
    }

    public int streamerCacheIndex() {
        return this.streamerCacheIndex;
    }

    public int streamerConcurrentCaches() {
        return this.streamerConcurrentCaches;
    }

    public int streamerBufferSize() {
        return this.streamerBufSize;
    }

    public int sqlRange() {
        return this.sqlRange;
    }

    public int clientNodesAfterId() {
        return this.clientNodesAfterId;
    }

    public String toString() {
        return GridToStringBuilder.toString(IgniteBenchmarkArguments.class, (Object)this);
    }
}

