/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.util.Arrays;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.Row;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class RowCsvInputFormat
extends CsvInputFormat<Row>
implements ResultTypeQueryable<Row> {
    private static final long serialVersionUID = 1L;
    private int arity;
    private TypeInformation[] fieldTypeInfos;
    private int[] fieldPosMap;
    private boolean emptyColumnAsNull;

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypeInfos, String lineDelimiter, String fieldDelimiter, int[] selectedFields, boolean emptyColumnAsNull) {
        super(filePath);
        this.arity = fieldTypeInfos.length;
        if (this.arity == 0) {
            throw new IllegalArgumentException("At least one field must be specified");
        }
        if (this.arity != selectedFields.length) {
            throw new IllegalArgumentException("Number of field types and selected fields must be the same");
        }
        this.fieldTypeInfos = fieldTypeInfos;
        this.fieldPosMap = RowCsvInputFormat.toFieldPosMap(selectedFields);
        this.emptyColumnAsNull = emptyColumnAsNull;
        boolean[] fieldsMask = RowCsvInputFormat.toFieldMask(selectedFields);
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        this.setFieldsGeneric(fieldsMask, RowCsvInputFormat.extractTypeClasses(fieldTypeInfos));
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, String lineDelimiter, String fieldDelimiter, int[] selectedFields) {
        this(filePath, fieldTypes, lineDelimiter, fieldDelimiter, selectedFields, false);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, String lineDelimiter, String fieldDelimiter) {
        this(filePath, fieldTypes, lineDelimiter, fieldDelimiter, RowCsvInputFormat.sequentialScanOrder(fieldTypes.length));
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, int[] selectedFields) {
        this(filePath, fieldTypes, "\n", ",", selectedFields);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, boolean emptyColumnAsNull) {
        this(filePath, fieldTypes, "\n", ",", RowCsvInputFormat.sequentialScanOrder(fieldTypes.length), emptyColumnAsNull);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes) {
        this(filePath, fieldTypes, false);
    }

    private static Class<?>[] extractTypeClasses(TypeInformation[] fieldTypes) {
        Class[] classes = new Class[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            classes[i] = fieldTypes[i].getTypeClass();
        }
        return classes;
    }

    private static int[] sequentialScanOrder(int arity) {
        int[] sequentialOrder = new int[arity];
        for (int i = 0; i < arity; ++i) {
            sequentialOrder[i] = i;
        }
        return sequentialOrder;
    }

    private static boolean[] toFieldMask(int[] selectedFields) {
        int maxField = 0;
        for (int selectedField : selectedFields) {
            maxField = Math.max(maxField, selectedField);
        }
        boolean[] mask = new boolean[maxField + 1];
        Arrays.fill(mask, false);
        for (int selectedField : selectedFields) {
            mask[selectedField] = true;
        }
        return mask;
    }

    private static int[] toFieldPosMap(int[] selectedFields) {
        int[] fieldIdxs = Arrays.copyOf(selectedFields, selectedFields.length);
        Arrays.sort(fieldIdxs);
        int[] fieldPosMap = new int[selectedFields.length];
        int i = 0;
        while (i < selectedFields.length) {
            int pos = Arrays.binarySearch(fieldIdxs, selectedFields[i]);
            fieldPosMap[pos] = i++;
        }
        return fieldPosMap;
    }

    @Override
    protected Row fillRecord(Row reuse, Object[] parsedValues) {
        Row reuseRow = reuse == null ? new Row(this.arity) : reuse;
        for (int i = 0; i < parsedValues.length; ++i) {
            reuseRow.setField(i, parsedValues[i]);
        }
        return reuseRow;
    }

    protected boolean parseRecord(Object[] holders, byte[] bytes, int offset, int numBytes) throws ParseException {
        byte[] fieldDelimiter = this.getFieldDelimiter();
        boolean[] fieldIncluded = this.fieldIncluded;
        int startPos = offset;
        int limit = offset + numBytes;
        int output = 0;
        for (int field = 0; field < fieldIncluded.length; ++field) {
            if (startPos > limit || startPos == limit && field != fieldIncluded.length - 1) {
                if (this.isLenient()) {
                    return false;
                }
                throw new ParseException("Row too short: " + new String(bytes, offset, numBytes, this.getCharset()));
            }
            if (fieldIncluded[field]) {
                FieldParser parser = this.getFieldParsers()[this.fieldPosMap[output]];
                int latestValidPos = startPos;
                startPos = parser.resetErrorStateAndParse(bytes, startPos, limit, fieldDelimiter, holders[this.fieldPosMap[output]]);
                if (!this.isLenient() && parser.getErrorState() != FieldParser.ParseErrorState.NONE && parser.getErrorState() != FieldParser.ParseErrorState.EMPTY_COLUMN) {
                    throw new ParseException(String.format("Parsing error for column %1$s of row '%2$s' originated by %3$s: %4$s.", field, new String(bytes, offset, numBytes), parser.getClass().getSimpleName(), parser.getErrorState()));
                }
                holders[this.fieldPosMap[output]] = parser.getLastResult();
                if (startPos < 0 || this.emptyColumnAsNull && parser.getErrorState().equals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN)) {
                    holders[this.fieldPosMap[output]] = null;
                    startPos = this.skipFields(bytes, latestValidPos, limit, fieldDelimiter);
                }
                ++output;
            } else {
                startPos = this.skipFields(bytes, startPos, limit, fieldDelimiter);
            }
            if (startPos < 0) {
                throw new ParseException(String.format("Unexpected parser position for column %1$s of row '%2$s'", field, new String(bytes, offset, numBytes)));
            }
            if (startPos != limit || field == fieldIncluded.length - 1 || FieldParser.endsWithDelimiter((byte[])bytes, (int)(startPos - 1), (byte[])fieldDelimiter)) continue;
            if (this.isLenient()) {
                return false;
            }
            throw new ParseException("Row too short: " + new String(bytes, offset, numBytes));
        }
        return true;
    }

    public TypeInformation<Row> getProducedType() {
        return new RowTypeInfo(this.fieldTypeInfos);
    }
}

