/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OtherAttributesAware;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorDefinitionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorDefinitionHelper.class);
    private static final ThreadLocal<RestoreAction> CURRENT_RESTORE_ACTION = new ThreadLocal();

    private ProcessorDefinitionHelper() {
    }

    public static <T> Iterator<T> filterTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        return ProcessorDefinitionHelper.filterTypeInOutputs(outputs, type, -1);
    }

    public static <T> Iterator<T> filterTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type, int maxDeep) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found, maxDeep);
        return found.iterator();
    }

    public static <T> T findFirstTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found, -1);
        if (found.isEmpty()) {
            return null;
        }
        return (T)found.iterator().next();
    }

    public static boolean isFirstChildOfType(Class<?> parentType, ProcessorDefinition<?> node) {
        if (node == null || node.getParent() == null) {
            return false;
        }
        if (node.getParent().getOutputs().isEmpty()) {
            return false;
        }
        if (!node.getParent().getClass().equals(parentType)) {
            return false;
        }
        return node.getParent().getOutputs().get(0).equals(node);
    }

    public static boolean isParentOfType(Class<?> parentType, ProcessorDefinition<?> node, boolean recursive) {
        if (node == null || node.getParent() == null) {
            return false;
        }
        if (parentType.isAssignableFrom(node.getParent().getClass())) {
            return true;
        }
        if (recursive) {
            return ProcessorDefinitionHelper.isParentOfType(parentType, node.getParent(), true);
        }
        return false;
    }

    public static RouteDefinition getRoute(ProcessorDefinition<?> node) {
        ProcessorDefinition<?> def;
        if (node == null) {
            return null;
        }
        for (def = node; def != null && def.getParent() != null; def = def.getParent()) {
        }
        if (def instanceof RouteDefinition) {
            return (RouteDefinition)def;
        }
        return null;
    }

    public static String getRouteId(ProcessorDefinition<?> node) {
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(node);
        return route != null ? route.getId() : null;
    }

    public static Set<String> gatherAllNodeIds(ProcessorDefinition<?> node, Set<String> set, boolean onlyCustomId, boolean includeAbstract) {
        List<ProcessorDefinition<?>> children;
        if (node == null) {
            return set;
        }
        if (node.isAbstract() && !includeAbstract) {
            return set;
        }
        if (set == null) {
            set = new LinkedHashSet<String>();
        }
        if (node.getId() != null && (!onlyCustomId || node.hasCustomIdAssigned() && onlyCustomId)) {
            set.add(node.getId());
        }
        if ((children = node.getOutputs()) != null && !children.isEmpty()) {
            for (ProcessorDefinition<?> child : children) {
                ProcessorDefinitionHelper.gatherAllNodeIds(child, set, onlyCustomId, includeAbstract);
            }
        }
        return set;
    }

    private static <T> void doFindType(List<ProcessorDefinition<?>> outputs, Class<T> type, List<T> found, int maxDeep) {
        if (maxDeep > 0) {
            for (ProcessorDefinition<?> out : outputs) {
                if (!out.isAbstract() || !out.isTopLevelOnly()) continue;
                ++maxDeep;
                break;
            }
        }
        ProcessorDefinitionHelper.doFindType(outputs, type, found, 1, maxDeep);
    }

    private static <T> void doFindType(List<ProcessorDefinition<?>> outputs, Class<T> type, List<T> found, int current, int maxDeep) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        if (maxDeep > 0 && current > maxDeep) {
            return;
        }
        for (ProcessorDefinition<?> out : outputs) {
            List<ProcessorDefinition<?>> children;
            if (out instanceof SendDefinition) {
                SendDefinition send = (SendDefinition)out;
                children = send.getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found, ++current, maxDeep);
            }
            if (out instanceof ChoiceDefinition) {
                ChoiceDefinition choice = (ChoiceDefinition)out;
                if (type.isInstance(choice)) {
                    found.add(choice);
                }
                if (maxDeep >= 0 && current >= maxDeep) continue;
                for (WhenDefinition when : choice.getWhenClauses()) {
                    if (type.isInstance(when)) {
                        found.add(when);
                    }
                    List<ProcessorDefinition<?>> children2 = when.getOutputs();
                    ProcessorDefinitionHelper.doFindType(children2, type, found, ++current, maxDeep);
                }
                if (choice.getOtherwise() == null) continue;
                children = choice.getOtherwise().getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found, ++current, maxDeep);
                continue;
            }
            if (out instanceof TryDefinition) {
                TryDefinition doTry = (TryDefinition)out;
                if (type.isInstance(doTry)) {
                    found.add(doTry);
                }
                if (maxDeep >= 0 && current >= maxDeep) continue;
                List<ProcessorDefinition<?>> doTryOut = doTry.getOutputsWithoutCatches();
                ProcessorDefinitionHelper.doFindType(doTryOut, type, found, ++current, maxDeep);
                List<CatchDefinition> doTryCatch = doTry.getCatchClauses();
                for (CatchDefinition doCatch : doTryCatch) {
                    ProcessorDefinitionHelper.doFindType(doCatch.getOutputs(), type, found, ++current, maxDeep);
                }
                if (doTry.getFinallyClause() == null) continue;
                ProcessorDefinitionHelper.doFindType(doTry.getFinallyClause().getOutputs(), type, found, ++current, maxDeep);
                continue;
            }
            if (out instanceof OutputDefinition) {
                OutputDefinition outDef = (OutputDefinition)out;
                if (type.isInstance(outDef)) {
                    found.add(outDef);
                }
                List<ProcessorDefinition<?>> outDefOut = outDef.getOutputs();
                ProcessorDefinitionHelper.doFindType(outDefOut, type, found, ++current, maxDeep);
                continue;
            }
            if (type.isInstance(out)) {
                found.add(out);
            }
            List<ProcessorDefinition<?>> children3 = out.getOutputs();
            ProcessorDefinitionHelper.doFindType(children3, type, found, ++current, maxDeep);
        }
    }

    public static boolean hasOutputs(List<ProcessorDefinition<?>> outputs, boolean excludeAbstract) {
        if (outputs == null || outputs.isEmpty()) {
            return false;
        }
        if (!excludeAbstract) {
            return !outputs.isEmpty();
        }
        for (ProcessorDefinition<?> output : outputs) {
            if (output instanceof TransactedDefinition || output instanceof PolicyDefinition) {
                return ProcessorDefinitionHelper.hasOutputs(output.getOutputs(), excludeAbstract);
            }
            if (output.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static boolean willCreateNewThreadPool(RouteContext routeContext, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return false;
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = routeContext.getCamelContext().getRegistry().lookupByNameAndType(definition.getExecutorServiceRef(), ExecutorService.class);
            return answer == null;
        }
        return useDefault;
    }

    public static ExecutorService lookupExecutorServiceRef(RouteContext routeContext, String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ExecutorService answer = routeContext.getCamelContext().getRegistry().lookupByNameAndType(executorServiceRef, ExecutorService.class);
        if (answer == null) {
            answer = manager.newThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public static ExecutorService getConfiguredExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return definition.getExecutorService();
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = ProcessorDefinitionHelper.lookupExecutorServiceRef(routeContext, name, definition, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultThreadPool(definition, name);
        }
        return null;
    }

    public static ScheduledExecutorService lookupScheduledExecutorServiceRef(RouteContext routeContext, String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ScheduledExecutorService answer = routeContext.getCamelContext().getRegistry().lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
        if (answer == null) {
            answer = manager.newScheduledThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public static ScheduledExecutorService getConfiguredScheduledExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            ExecutorService executorService = definition.getExecutorService();
            if (executorService instanceof ScheduledExecutorService) {
                return (ScheduledExecutorService)executorService;
            }
            throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " is not an ScheduledExecutorService instance");
        }
        if (definition.getExecutorServiceRef() != null) {
            ScheduledExecutorService answer = ProcessorDefinitionHelper.lookupScheduledExecutorServiceRef(routeContext, name, definition, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultScheduledThreadPool(definition, name);
        }
        return null;
    }

    public static Runnable createPropertyPlaceholdersChangeReverter() {
        RestoreAction prevChanges = CURRENT_RESTORE_ACTION.get();
        RestoreAction rc = new RestoreAction(prevChanges);
        CURRENT_RESTORE_ACTION.set(rc);
        return rc;
    }

    private static void addRestoreAction(final Object target, final Map<String, Object> properties) {
        if (properties.isEmpty()) {
            return;
        }
        RestoreAction restoreAction = CURRENT_RESTORE_ACTION.get();
        if (restoreAction == null) {
            return;
        }
        restoreAction.actions.add(new Runnable(){

            @Override
            public void run() {
                try {
                    IntrospectionSupport.setProperties(null, target, properties);
                }
                catch (Exception e) {
                    LOG.warn("Could not restore definition properties", (Throwable)e);
                }
            }
        });
    }

    public static void addPropertyPlaceholdersChangeRevertAction(Runnable action) {
        RestoreAction restoreAction = CURRENT_RESTORE_ACTION.get();
        if (restoreAction == null) {
            return;
        }
        restoreAction.actions.add(action);
    }

    @Deprecated
    public static void resolvePropertyPlaceholders(RouteContext routeContext, Object definition) throws Exception {
        ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), definition);
    }

    public static void resolvePropertyPlaceholders(CamelContext camelContext, Object definition) throws Exception {
        LOG.trace("Resolving property placeholders for: {}", definition);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(definition, properties, null);
        OtherAttributesAware other = null;
        if (definition instanceof OtherAttributesAware) {
            other = (OtherAttributesAware)definition;
        }
        if (other != null && other.getOtherAttributes() != null) {
            for (QName key : other.getOtherAttributes().keySet()) {
                if (!"http://camel.apache.org/schema/placeholder".equals(key.getNamespaceURI())) continue;
                String local = key.getLocalPart();
                Object value = other.getOtherAttributes().get(key);
                if (value != null && value instanceof String) {
                    CamelContextHelper.lookupPropertiesComponent(camelContext, true);
                    String s = (String)value;
                    String prefixToken = camelContext.getPropertyPrefixToken();
                    String suffixToken = camelContext.getPropertySuffixToken();
                    if (prefixToken == null) {
                        throw new IllegalArgumentException("Property with name [" + local + "] uses property placeholders; however, no properties component is configured.");
                    }
                    if (!s.startsWith(prefixToken)) {
                        s = prefixToken + s;
                    }
                    if (!s.endsWith(suffixToken)) {
                        s = s + suffixToken;
                    }
                    value = s;
                }
                properties.put(local, value);
            }
        }
        HashMap<String, Object> changedProperties = new HashMap<String, Object>();
        if (!properties.isEmpty()) {
            LOG.trace("There are {} properties on: {}", (Object)properties.size(), definition);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                String text = (String)value;
                if ((text = camelContext.resolvePropertyPlaceholders(text)) == value) continue;
                boolean changed = IntrospectionSupport.setProperty(camelContext.getTypeConverter(), definition, name, text);
                if (!changed) {
                    throw new IllegalArgumentException("No setter to set property: " + name + " to: " + text + " on: " + definition);
                }
                changedProperties.put(name, value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, text});
            }
        }
        ProcessorDefinitionHelper.addRestoreAction(definition, changedProperties);
    }

    public static void resolveKnownConstantFields(Object definition) throws Exception {
        LOG.trace("Resolving known fields for: {}", definition);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(definition, properties, null);
        HashMap<String, Object> changedProperties = new HashMap<String, Object>();
        if (!properties.isEmpty()) {
            LOG.trace("There are {} properties on: {}", (Object)properties.size(), definition);
            for (Map.Entry entry : properties.entrySet()) {
                String text;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String) || !(text = (String)value).startsWith("Exchange.")) continue;
                String field = ObjectHelper.after(text, "Exchange.");
                String constant = ObjectHelper.lookupConstantFieldValue(Exchange.class, field);
                if (constant != null) {
                    IntrospectionSupport.setProperty(definition, name, constant);
                    changedProperties.put(name, value);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, constant});
                    continue;
                }
                throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
            }
        }
        ProcessorDefinitionHelper.addRestoreAction(definition, changedProperties);
    }

    private static final class RestoreAction
    implements Runnable {
        private final RestoreAction prevChange;
        private final ArrayList<Runnable> actions = new ArrayList();

        private RestoreAction(RestoreAction prevChange) {
            this.prevChange = prevChange;
        }

        @Override
        public void run() {
            for (Runnable action : this.actions) {
                action.run();
            }
            this.actions.clear();
            if (this.prevChange == null) {
                CURRENT_RESTORE_ACTION.remove();
            } else {
                CURRENT_RESTORE_ACTION.set(this.prevChange);
            }
        }
    }
}

