/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.compatibility.testsuites;

import junit.framework.TestSuite;
import org.apache.ignite.compatibility.persistence.DummyPersistenceCompatibilityTest;
import org.apache.ignite.compatibility.persistence.FoldersReuseCompatibilityTest;
import org.apache.ignite.compatibility.persistence.IgniteUuidCompatibilityTest;
import org.apache.ignite.compatibility.persistence.MigratingToWalV2SerializerWithCompactionTest;

/**
 * Compatibility tests basic test suite.
 */
public class IgniteCompatibilityBasicTestSuite {
    /**
     * @return Test suite.
     * @throws Exception In case of an error.
     */
    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite("Ignite Compatibility Basic Test Suite");

        suite.addTestSuite(DummyPersistenceCompatibilityTest.class);

        suite.addTestSuite(FoldersReuseCompatibilityTest.class);

        suite.addTestSuite(MigratingToWalV2SerializerWithCompactionTest.class);

        suite.addTestSuite(IgniteUuidCompatibilityTest.class);

        return suite;
    }
}
