/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery;

import java.util.Collection;
import java.util.NavigableMap;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.tracing.messages.SpanContainer;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.jetbrains.annotations.Nullable;

public class DiscoveryNotification {
    private final int eventType;
    private final long topVer;
    private final ClusterNode node;
    private final Collection<ClusterNode> topSnapshot;
    @Nullable
    private NavigableMap<Long, Collection<ClusterNode>> topHist;
    @Nullable
    private DiscoverySpiCustomMessage customMsgData;
    private SpanContainer spanContainer;

    public DiscoveryNotification(int eventType, long topVer, ClusterNode node, Collection<ClusterNode> topSnapshot) {
        this.eventType = eventType;
        this.topVer = topVer;
        this.node = node;
        this.topSnapshot = topSnapshot;
    }

    public DiscoveryNotification(int eventType, long topVer, ClusterNode node, Collection<ClusterNode> topSnapshot, @Nullable NavigableMap<Long, Collection<ClusterNode>> topHist, @Nullable DiscoverySpiCustomMessage customMsgData, SpanContainer spanContainer) {
        this.eventType = eventType;
        this.topVer = topVer;
        this.node = node;
        this.topSnapshot = topSnapshot;
        this.topHist = topHist;
        this.customMsgData = customMsgData;
        this.spanContainer = spanContainer;
    }

    public int type() {
        return this.eventType;
    }

    public long getTopVer() {
        return this.topVer;
    }

    public ClusterNode getNode() {
        return this.node;
    }

    public Collection<ClusterNode> getTopSnapshot() {
        return this.topSnapshot;
    }

    public NavigableMap<Long, Collection<ClusterNode>> getTopHist() {
        return this.topHist;
    }

    public DiscoverySpiCustomMessage getCustomMsgData() {
        return this.customMsgData;
    }

    public SpanContainer getSpanContainer() {
        return this.spanContainer;
    }
}

