/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.processors.platform.cache.PlatformCache;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheFieldsQueryCursor;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheSqlFieldsQueryResponse;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.plugin.security.SecurityException;

public class ClientCacheSqlFieldsQueryRequest
extends ClientCacheQueryRequest
implements ClientTxAwareRequest {
    private final SqlFieldsQuery qry;
    private final boolean includeFieldNames;
    private final int[] partitions;
    private final Integer updateBatchSize;

    public ClientCacheSqlFieldsQueryRequest(BinaryRawReaderEx reader, ClientProtocolContext protocolCtx) {
        super(reader);
        String schema = reader.readString();
        int pageSize = reader.readInt();
        reader.readInt();
        String sql = reader.readString();
        Object[] args = PlatformCache.readQueryArgs(reader);
        JdbcStatementType stmtType = JdbcStatementType.fromOrdinal(reader.readByte());
        boolean distributedJoins = reader.readBoolean();
        boolean loc = reader.readBoolean();
        boolean replicatedOnly = reader.readBoolean();
        boolean enforceJoinOrder = reader.readBoolean();
        boolean collocated = reader.readBoolean();
        boolean lazy = reader.readBoolean();
        int timeout = (int)reader.readLong();
        this.includeFieldNames = reader.readBoolean();
        SqlFieldsQuery qry = stmtType == JdbcStatementType.ANY_STATEMENT_TYPE ? new SqlFieldsQuery(sql) : new SqlFieldsQueryEx(sql, (Boolean)(stmtType == JdbcStatementType.SELECT_STATEMENT_TYPE ? 1 : 0));
        qry.setSchema(schema).setPageSize(pageSize).setArgs(args).setDistributedJoins(distributedJoins).setLocal(loc).setReplicatedOnly(replicatedOnly).setEnforceJoinOrder(enforceJoinOrder).setCollocated(collocated).setLazy(lazy);
        if (protocolCtx.isFeatureSupported(ClientBitmaskFeature.DEFAULT_QRY_TIMEOUT) || timeout > 0) {
            QueryUtils.withQueryTimeout(qry, timeout, TimeUnit.MILLISECONDS);
        }
        this.qry = qry;
        if (protocolCtx.isFeatureSupported(ClientBitmaskFeature.QRY_PARTITIONS_BATCH_SIZE)) {
            int partCnt = reader.readInt();
            if (partCnt >= 0) {
                this.partitions = new int[partCnt];
                for (int i = 0; i < partCnt; ++i) {
                    this.partitions[i] = reader.readInt();
                }
            } else {
                this.partitions = null;
            }
            this.updateBatchSize = reader.readInt();
        } else {
            this.partitions = null;
            this.updateBatchSize = null;
        }
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        this.qry.setPartitions(this.partitions);
        if (this.updateBatchSize != null) {
            this.qry.setUpdateBatchSize(this.updateBatchSize);
        }
        ctx.incrementCursors();
        try {
            this.qry.setQueryInitiatorId(ctx.clientDescriptor());
            if (this.cacheId() != 0) {
                DynamicCacheDescriptor desc = this.cacheDescriptor(ctx);
                if (this.qry.getSchema() == null) {
                    String schema = QueryUtils.normalizeSchemaName(desc.cacheName(), desc.cacheConfiguration().getSqlSchema());
                    this.qry.setSchema(schema);
                }
            }
            List<FieldsQueryCursor<List<?>>> curs = ctx.kernalContext().query().querySqlFields(this.qry, true, true);
            assert (curs.size() == 1);
            FieldsQueryCursor<List> cur = curs.get(0);
            ClientCacheFieldsQueryCursor cliCur = new ClientCacheFieldsQueryCursor(cur, this.qry.getPageSize(), ctx);
            long cursorId = ctx.resources().put(cliCur);
            cliCur.id(cursorId);
            return new ClientCacheSqlFieldsQueryResponse(this.requestId(), cliCur, cur, this.includeFieldNames);
        }
        catch (Exception e) {
            ctx.decrementCursors();
            SecurityException securityEx = X.cause(e, SecurityException.class);
            if (securityEx != null) {
                throw new IgniteClientException(1012, "Client is not authorized to perform this operation", securityEx);
            }
            throw e;
        }
    }
}

