/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc.dialect;

import java.util.Collection;
import org.apache.ignite.cache.store.jdbc.dialect.BasicJdbcDialect;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;

public class OracleDialect
extends BasicJdbcDialect {
    private static final long serialVersionUID = 0L;

    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = OracleDialect.mkString(keyCols, ",");
        return String.format("SELECT %1$s FROM (SELECT %1$s, ROWNUM AS rn FROM (SELECT %1$s FROM %2$s ORDER BY %1$s)) WHERE mod(rn, ?) = 0", cols, fullTblName);
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection<String> cols = F.concat(false, keyCols, uniqCols);
        String colsLst = OracleDialect.mkString(cols, ", ");
        String selCols = OracleDialect.mkString(cols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return String.format("? AS %s", col);
            }
        }, "", ", ", "");
        String match = OracleDialect.mkString(keyCols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return String.format("t.%s=v.%s", col, col);
            }
        }, "(", " AND ", ")");
        String setCols = OracleDialect.mkString(uniqCols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return String.format("t.%s = v.%s", col, col);
            }
        }, "", ", ", "");
        String valuesCols = OracleDialect.mkString(cols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return "v." + col;
            }
        }, "", ", ", "");
        String whenMatched = !uniqCols.isEmpty() ? String.format(" WHEN MATCHED THEN UPDATE SET %s", setCols) : "";
        return String.format("MERGE INTO %s t USING (SELECT %s FROM dual) v  ON %s%s WHEN NOT MATCHED THEN  INSERT (%s) VALUES (%s)", fullTblName, selCols, match, whenMatched, colsLst, valuesCols);
    }
}

