/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.google.common.base.Supplier;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.runtime.Matcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Enumerables {
    private Enumerables() {
    }

    public static <E> Enumerable<E> slice0(Enumerable<E[]> enumerable) {
        return enumerable.select(elements -> elements[0]);
    }

    public static Enumerable<Row> toRow(Enumerable<@Nullable Object[]> enumerable) {
        return enumerable.select(Row::asCopy);
    }

    public static java.util.function.Supplier<Enumerable<Row>> toRow(java.util.function.Supplier<Enumerable<@Nullable Object[]>> supplier) {
        return () -> Enumerables.toRow((Enumerable<Object[]>)((Enumerable)supplier.get()));
    }

    @Deprecated
    public static Supplier<Enumerable<Row>> toRow(Supplier<Enumerable<@Nullable Object[]>> supplier) {
        return () -> Enumerables.toRow((Enumerable<Object[]>)((Enumerable)supplier.get()));
    }

    public static <E, TKey, TResult> Enumerable<TResult> match(final Enumerable<E> enumerable, final Function1<E, TKey> keySelector, final Matcher<E> matcher, final Emitter<E, TResult> emitter, final int history, final int future) {
        return new AbstractEnumerable<TResult>(){

            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<E> inputEnumerator;
                    final Map<TKey, Matcher.PartitionState<E>> partitionStates;
                    int inputRow;
                    final Deque<TResult> emitRows;
                    @Nullable TResult resultRow;
                    final AtomicInteger matchCounter;
                    {
                        this.inputEnumerator = enumerable.enumerator();
                        this.partitionStates = new HashMap();
                        this.inputRow = -1;
                        this.emitRows = new ArrayDeque();
                        this.matchCounter = new AtomicInteger(1);
                    }

                    public TResult current() {
                        Objects.requireNonNull(this.resultRow, "resultRow");
                        return this.resultRow;
                    }

                    public boolean moveNext() {
                        while (true) {
                            this.resultRow = this.emitRows.pollFirst();
                            if (this.resultRow != null) {
                                return true;
                            }
                            if (!this.inputEnumerator.moveNext()) {
                                return false;
                            }
                            ++this.inputRow;
                            Object row = this.inputEnumerator.current();
                            Object key = keySelector.apply(row);
                            Matcher.PartitionState partitionState = this.partitionStates.computeIfAbsent(key, k -> matcher.createPartitionState(history, future));
                            partitionState.getMemoryFactory().add(row);
                            matcher.matchOne(partitionState.getRows(), partitionState, matches -> emitter.emit(matches.rows, (List<Integer>)null, (List<String>)matches.symbols, this.matchCounter.getAndIncrement(), this.emitRows::add));
                        }
                    }

                    public void reset() {
                        throw new UnsupportedOperationException();
                    }

                    public void close() {
                        this.inputEnumerator.close();
                    }
                };
            }
        };
    }

    public static interface Emitter<E, TResult> {
        public void emit(List<E> var1, @Nullable List<Integer> var2, List<String> var3, int var4, Consumer<TResult> var5);
    }
}

