/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.ignite.internal.util.typedef.internal.U;

public class JdbcBinaryBuffer {
    private byte[] arr;
    private int off;
    private int len;
    private boolean isReadOnly;
    public static final int MIN_CAP = 256;

    public static JdbcBinaryBuffer createReadOnly(byte[] arr, int off, int len) {
        return new JdbcBinaryBuffer(arr, off, len, true);
    }

    public static JdbcBinaryBuffer createReadWrite(byte[] arr) {
        return new JdbcBinaryBuffer(arr, 0, arr.length, false);
    }

    public static JdbcBinaryBuffer createReadWrite() {
        return new JdbcBinaryBuffer(new byte[256], 0, 0, false);
    }

    private JdbcBinaryBuffer(byte[] arr, int off, int len, boolean isReadOnly) {
        this.arr = arr;
        this.off = off;
        this.len = len;
        this.isReadOnly = isReadOnly;
    }

    public JdbcBinaryBuffer shallowCopy() {
        return new JdbcBinaryBuffer(this.arr, this.off, this.len, true);
    }

    public InputStream inputStream() {
        return new BufferInputStream();
    }

    public byte[] bytes() {
        byte[] bytes = new byte[this.len];
        this.read(0, bytes, 0, this.len);
        return bytes;
    }

    OutputStream outputStream(int pos) {
        return new BufferOutputStream(pos);
    }

    InputStream inputStream(int pos, int len) {
        return new BufferInputStream(pos, pos + len);
    }

    void truncate(int len) {
        this.len = len;
        this.reallocate(Math.max(256, len));
    }

    int length() {
        return this.len;
    }

    int read(int pos, byte[] resBuf, int resOff, int resLen) {
        Objects.checkFromIndexSize(resOff, resLen, resBuf.length);
        if (pos >= this.len) {
            return -1;
        }
        int bufOff = pos + this.off;
        int size = Math.min(resLen, this.len - pos);
        U.arrayCopy(this.arr, bufOff, resBuf, resOff, size);
        return size;
    }

    void write(int pos, byte[] inpBuf, int inpOff, int inpLen) throws IOException {
        if (0x7FFFFFF7 - pos < inpLen) {
            throw new IOException("Too much data. Can't write more then 2147483639 bytes.");
        }
        Objects.checkFromIndexSize(inpOff, inpLen, inpBuf.length);
        this.updateLength(Math.max(pos + inpLen, this.len));
        U.arrayCopy(inpBuf, inpOff, this.arr, pos, inpLen);
    }

    int read(int pos) {
        if (pos >= this.len) {
            return -1;
        }
        return this.arr[pos + this.off] & 0xFF;
    }

    void write(int pos, int b) throws IOException {
        if (0x7FFFFFF7 - pos < 1) {
            throw new IOException("Too much data. Can't write more then 2147483639 bytes.");
        }
        this.updateLength(Math.max(pos + 1, this.len));
        this.arr[pos] = (byte)b;
    }

    private void updateLength(int newLen) {
        if (newLen > this.arr.length || this.isReadOnly) {
            this.reallocate(JdbcBinaryBuffer.capacity(this.arr.length, newLen));
        }
        this.len = newLen;
    }

    protected static int capacity(int cap, int reqCap) {
        if (reqCap <= 256) {
            return 256;
        }
        int resCap = Math.max(cap, 256);
        while (resCap < reqCap) {
            if ((resCap <<= 1) >= 0) continue;
            return 0x7FFFFFF7;
        }
        return resCap;
    }

    private void reallocate(int newCapacity) {
        byte[] newBuf = new byte[newCapacity];
        U.arrayCopy(this.arr, this.off, newBuf, 0, this.len);
        this.arr = newBuf;
        this.off = 0;
        this.isReadOnly = false;
    }

    private class BufferOutputStream
    extends OutputStream {
        private int pos;

        private BufferOutputStream(int pos) {
            this.pos = pos;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.pos > JdbcBinaryBuffer.this.length()) {
                throw new IOException("Writting beyond end of Blob, it probably was truncated after OutputStream was created [pos=" + this.pos + ", blobLength=" + JdbcBinaryBuffer.this.length() + "]");
            }
            JdbcBinaryBuffer.this.write(this.pos++, b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.pos > JdbcBinaryBuffer.this.length()) {
                throw new IOException("Writting beyond end of Blob, it probably was truncated after OutputStream was created [pos=" + this.pos + ", blobLength=" + JdbcBinaryBuffer.this.length() + "]");
            }
            JdbcBinaryBuffer.this.write(this.pos, b, off, len);
            this.pos += len;
        }
    }

    private class BufferInputStream
    extends InputStream {
        private final int limit;
        private int pos;
        private int markedPos;

        private BufferInputStream() {
            this(0, -1);
        }

        private BufferInputStream(int start, int limit) {
            this.pos = start;
            this.markedPos = start;
            this.limit = limit;
        }

        @Override
        public int read() {
            if (this.limit != -1 && this.pos >= this.limit) {
                return -1;
            }
            int res = JdbcBinaryBuffer.this.read(this.pos);
            if (res != -1) {
                ++this.pos;
            }
            return res;
        }

        @Override
        public int read(byte[] res, int off, int cnt) {
            int read;
            Objects.checkFromIndexSize(off, cnt, res.length);
            int toRead = cnt;
            if (this.limit != -1) {
                if (this.pos >= this.limit) {
                    return -1;
                }
                toRead = Math.min(this.limit - this.pos, cnt);
            }
            if ((read = JdbcBinaryBuffer.this.read(this.pos, res, off, toRead)) != -1) {
                this.pos += read;
            }
            return read;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void reset() {
            this.pos = this.markedPos;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.markedPos = this.pos;
        }

        @Override
        public long skip(long n) {
            if (n <= 0L) {
                return 0L;
            }
            int step = Math.min((int)Math.min(n, 0x7FFFFFF7L), this.limit == -1 ? JdbcBinaryBuffer.this.len - this.pos : this.limit - this.pos);
            this.pos += step;
            return step;
        }
    }
}

