/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteJdbcThinDriver;
import org.apache.ignite.internal.jdbc.thin.ConnectionPropertiesImpl;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.typedef.F;

public class IgniteJdbcThinDataSource
implements DataSource,
Serializable {
    private static final long serialVersionUID = 0L;
    private ConnectionPropertiesImpl props = new ConnectionPropertiesImpl();
    private int loginTimeout;

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String pwd) throws SQLException {
        Properties props = this.props.storeToProperties();
        if (!F.isEmpty(username)) {
            props.put("user", username);
        }
        if (!F.isEmpty(pwd)) {
            props.put("password", pwd);
        }
        return IgniteJdbcThinDriver.register().connect(this.getUrl(), props);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("DataSource is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(IgniteJdbcThinDataSource.class);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("org.apache.ignite");
    }

    public String getURL() {
        return this.getUrl();
    }

    public void setURL(String url) throws SQLException {
        this.setUrl(url);
    }

    public String[] getAddresses() {
        HostAndPortRange[] addrs = this.props.getAddresses();
        if (addrs == null) {
            return null;
        }
        String[] addrsStr = new String[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            addrsStr[i] = addrs[i].toString();
        }
        return addrsStr;
    }

    public void setAddresses(String ... addrsStr) throws SQLException {
        HostAndPortRange[] addrs = new HostAndPortRange[addrsStr.length];
        for (int i = 0; i < addrs.length; ++i) {
            try {
                addrs[i] = HostAndPortRange.parse(addrsStr[i], 10800, 10800, "Invalid endpoint format (should be \"host[:portRangeFrom[..portRangeTo]]\")");
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new SQLException(e.getMessage(), "08001", e);
            }
        }
        this.props.setAddresses(addrs);
    }

    public String getSchema() {
        return this.props.getSchema();
    }

    public void setSchema(String schema) {
        this.props.setSchema(schema);
    }

    public String getUrl() {
        return this.props.getUrl();
    }

    public void setUrl(String url) throws SQLException {
        this.props = new ConnectionPropertiesImpl();
        this.props.setUrl(url);
    }

    public boolean isDistributedJoins() {
        return this.props.isDistributedJoins();
    }

    public void setDistributedJoins(boolean distributedJoins) {
        this.props.setDistributedJoins(distributedJoins);
    }

    public boolean isEnforceJoinOrder() {
        return this.props.isEnforceJoinOrder();
    }

    public void setEnforceJoinOrder(boolean enforceJoinOrder) {
        this.props.setEnforceJoinOrder(enforceJoinOrder);
    }

    public boolean isCollocated() {
        return this.props.isCollocated();
    }

    public void setCollocated(boolean collocated) {
        this.props.setCollocated(collocated);
    }

    public boolean isReplicatedOnly() {
        return this.props.isReplicatedOnly();
    }

    public void setReplicatedOnly(boolean replicatedOnly) {
        this.props.setReplicatedOnly(replicatedOnly);
    }

    public boolean isAutoCloseServerCursor() {
        return this.props.isAutoCloseServerCursor();
    }

    public void setAutoCloseServerCursor(boolean autoCloseServerCursor) {
        this.props.setAutoCloseServerCursor(autoCloseServerCursor);
    }

    public int getSocketSendBuffer() {
        return this.props.getSocketSendBuffer();
    }

    public void setSocketSendBuffer(int size) throws SQLException {
        this.props.setSocketSendBuffer(size);
    }

    public int getSocketReceiveBuffer() {
        return this.props.getSocketReceiveBuffer();
    }

    public void setSocketReceiveBuffer(int size) throws SQLException {
        this.props.setSocketReceiveBuffer(size);
    }

    public boolean isTcpNoDelay() {
        return this.props.isTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.props.setTcpNoDelay(tcpNoDelay);
    }

    public boolean isLazy() {
        return this.props.isLazy();
    }

    public void setLazy(boolean lazy) {
        this.props.setLazy(lazy);
    }

    public boolean isSkipReducerOnUpdate() {
        return this.props.isSkipReducerOnUpdate();
    }

    public void setSkipReducerOnUpdate(boolean skipReducerOnUpdate) {
        this.props.setSkipReducerOnUpdate(skipReducerOnUpdate);
    }

    public String getSslMode() {
        return this.props.getSslMode();
    }

    public void setSslMode(String mode) {
        this.props.setSslMode(mode);
    }

    public String getSslProtocol() {
        return this.props.getSslProtocol();
    }

    public void setSslProtocol(String sslProtocol) {
        this.props.setSslProtocol(sslProtocol);
    }

    public String getCipherSuites() {
        return this.props.getSslCipherSuites();
    }

    public void setCipherSuites(String cipherSuites) {
        this.props.setSslCipherSuites(cipherSuites);
    }

    public String getSslKeyAlgorithm() {
        return this.props.getSslKeyAlgorithm();
    }

    public void setSslKeyAlgorithm(String keyAlgorithm) {
        this.props.setSslKeyAlgorithm(keyAlgorithm);
    }

    public String getSslClientCertificateKeyStoreUrl() {
        return this.props.getSslClientCertificateKeyStoreUrl();
    }

    public void setSslClientCertificateKeyStoreUrl(String url) {
        this.props.setSslClientCertificateKeyStoreUrl(url);
    }

    public String getSslClientCertificateKeyStorePassword() {
        return this.props.getSslClientCertificateKeyStorePassword();
    }

    public void setSslClientCertificateKeyStorePassword(String passwd) {
        this.props.setSslClientCertificateKeyStorePassword(passwd);
    }

    public String getSslClientCertificateKeyStoreType() {
        return this.props.getSslClientCertificateKeyStoreType();
    }

    public void setSslClientCertificateKeyStoreType(String ksType) {
        this.props.setSslClientCertificateKeyStoreType(ksType);
    }

    public String getSslTrustCertificateKeyStoreUrl() {
        return this.props.getSslTrustCertificateKeyStoreUrl();
    }

    public void setSslTrustCertificateKeyStoreUrl(String url) {
        this.props.setSslTrustCertificateKeyStoreUrl(url);
    }

    public String getSslTrustCertificateKeyStorePassword() {
        return this.props.getSslTrustCertificateKeyStorePassword();
    }

    public void setSslTrustCertificateKeyStorePassword(String passwd) {
        this.props.setSslTrustCertificateKeyStorePassword(passwd);
    }

    public String getSslTrustCertificateKeyStoreType() {
        return this.props.getSslTrustCertificateKeyStoreType();
    }

    public void setSslTrustCertificateKeyStoreType(String ksType) {
        this.props.setSslTrustCertificateKeyStoreType(ksType);
    }

    public boolean isSslTrustAll() {
        return this.props.isSslTrustAll();
    }

    public void setSslTrustAll(boolean trustAll) {
        this.props.setSslTrustAll(trustAll);
    }

    public String getSslFactory() {
        return this.props.getSslFactory();
    }

    public void setSslFactory(String sslFactory) {
        this.props.setSslFactory(sslFactory);
    }

    public void setUsername(String name) {
        this.props.setUsername(name);
    }

    public String getUsername() {
        return this.props.getUsername();
    }

    public void setPassword(String passwd) {
        this.props.setPassword(passwd);
    }

    public String getPassword() {
        return this.props.getPassword();
    }
}

