/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.internal;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    public static final boolean IS_RESTRICTED_APPENGINE = System.getProperty("com.google.appengine.runtime.environment") != null && "1.7".equals(System.getProperty("java.specification.version"));
    private static final String DELIMITER = "-";
    private static final ThreadFactory threadFactory = MoreExecutors.platformThreadFactory();
    private final AtomicInteger threadIdGen = new AtomicInteger();
    private final String threadPrefix;

    public DaemonThreadFactory(String threadPrefix) {
        this.threadPrefix = threadPrefix + DELIMITER;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = threadFactory.newThread(r);
        if (!IS_RESTRICTED_APPENGINE) {
            thread.setName(this.threadPrefix + this.threadIdGen.getAndIncrement());
            thread.setDaemon(true);
        }
        return thread;
    }
}

