/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.systemview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommandArg;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTaskArg;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTaskResult;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public class SystemViewCommand
extends AbstractCommand<VisorSystemViewTaskArg> {
    public static final String COLUMN_SEPARATOR = "    ";
    private VisorSystemViewTaskArg taskArg;
    private Collection<UUID> nodeIds;
    private boolean allNodes;

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try {
            VisorSystemViewTaskResult res;
            try (GridClient client = Command.startClient(clientCfg);){
                Collection connectable;
                GridClientCompute compute = client.compute();
                Map<UUID, GridClientNode> clusterNodes = compute.nodes().stream().collect(Collectors.toMap(GridClientNode::nodeId, n -> n));
                if (this.allNodes) {
                    this.nodeIds = clusterNodes.keySet();
                } else if (F.isEmpty(this.nodeIds)) {
                    this.nodeIds = Collections.singleton(TaskExecutor.getBalancedNode(compute).nodeId());
                } else {
                    for (UUID id2 : this.nodeIds) {
                        if (clusterNodes.containsKey(id2)) continue;
                        throw new IllegalArgumentException("Node with id=" + id2 + " not found.");
                    }
                }
                if (!F.isEmpty((Collection)(connectable = F.viewReadOnly(this.nodeIds, clusterNodes::get, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)id -> ((GridClientNode)clusterNodes.get(id)).connectable()})))) {
                    compute = compute.projection(connectable);
                }
                res = (VisorSystemViewTaskResult)compute.execute(VisorSystemViewTask.class.getName(), (Object)new VisorTaskArgument(this.nodeIds, (Object)this.taskArg, false));
            }
            if (res != null) {
                res.rows().forEach((nodeId, rows) -> {
                    log.info("Results from node with ID: " + nodeId);
                    log.info("---");
                    SystemViewCommand.printTable(res.attributes(), res.types(), rows, log);
                    log.info("---" + U.nl());
                });
            } else {
                log.info("No system view with specified name was found [name=" + this.taskArg.systemViewName() + "]");
            }
            return res;
        }
        catch (Throwable e) {
            log.error("Failed to perform operation.");
            log.error(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    public static void printTable(List<String> titles, List<VisorSystemViewTask.SimpleType> types, List<List<?>> data, IgniteLogger log) {
        List<Integer> colSzs = titles != null ? titles.stream().map(String::length).collect(Collectors.toList()) : types.stream().map(x -> 0).collect(Collectors.toList());
        ArrayList rows = new ArrayList(data.size());
        data.forEach(row -> {
            ListIterator colSzIter = colSzs.listIterator();
            rows.add(row.stream().map(val -> {
                String res = String.valueOf(val);
                colSzIter.set(Math.max((Integer)colSzIter.next(), res.length()));
                return res;
            }).collect(Collectors.toList()));
        });
        if (titles != null) {
            SystemViewCommand.printRow(titles, Collections.nCopies(titles.size(), VisorSystemViewTask.SimpleType.STRING), colSzs, log);
        }
        rows.forEach(row -> SystemViewCommand.printRow(row, types, colSzs, log));
    }

    private static void printRow(Collection<String> row, Collection<VisorSystemViewTask.SimpleType> types, Collection<Integer> colSzs, IgniteLogger log) {
        Iterator<VisorSystemViewTask.SimpleType> typeIter = types.iterator();
        Iterator<Integer> colSzsIter = colSzs.iterator();
        log.info(row.stream().map(colVal -> {
            VisorSystemViewTask.SimpleType colType = (VisorSystemViewTask.SimpleType)typeIter.next();
            int colSz = (Integer)colSzsIter.next();
            String format = colType == VisorSystemViewTask.SimpleType.DATE || colType == VisorSystemViewTask.SimpleType.NUMBER ? "%" + colSz + "s" : "%-" + colSz + "s";
            return String.format(format, colVal);
        }).collect(Collectors.joining(COLUMN_SEPARATOR)));
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.nodeIds = null;
        this.allNodes = false;
        String sysViewName = null;
        while (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg("Failed to read command argument.");
            SystemViewCommandArg cmdArg = CommandArgUtils.of(arg, SystemViewCommandArg.class);
            if (cmdArg == SystemViewCommandArg.NODE_ID || cmdArg == SystemViewCommandArg.NODE_IDS) {
                if (this.nodeIds != null) {
                    throw new IllegalArgumentException("Only one of " + SystemViewCommandArg.NODE_ID + ", " + SystemViewCommandArg.NODE_IDS + " commands is expected.");
                }
                String idsArg = argIter.nextArg(cmdArg == SystemViewCommandArg.NODE_ID ? "ID of the node from which system view content should be obtained is expected." : "Comma-separated list of node IDs from which system view content should be obtained is expected.");
                this.nodeIds = F.viewReadOnly(argIter.parseStringSet(idsArg), (IgniteClosure & Serializable)name -> {
                    try {
                        return UUID.fromString(name);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Failed to parse " + (cmdArg == SystemViewCommandArg.NODE_ID ? SystemViewCommandArg.NODE_ID : SystemViewCommandArg.NODE_IDS) + " command argument. String representation of \"java.util.UUID\" is exepected. For example: 123e4567-e89b-42d3-a456-556642440000", e);
                    }
                }, (IgnitePredicate[])new IgnitePredicate[0]);
                continue;
            }
            if (cmdArg == SystemViewCommandArg.ALL_NODES) {
                this.allNodes = true;
                continue;
            }
            if (sysViewName != null) {
                throw new IllegalArgumentException("Multiple system view names are not supported.");
            }
            sysViewName = arg;
        }
        if (this.allNodes && !F.isEmpty(this.nodeIds)) {
            throw new IllegalArgumentException("The " + SystemViewCommandArg.ALL_NODES + " parameter cannot be used with specified node IDs.");
        }
        if (sysViewName == null) {
            throw new IllegalArgumentException("The name of the system view for which its content should be printed is expected.");
        }
        this.taskArg = new VisorSystemViewTaskArg(sysViewName);
    }

    @Override
    public VisorSystemViewTaskArg arg() {
        return this.taskArg;
    }

    @Override
    public void printUsage(IgniteLogger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("system_view_name", "Name of the system view which content should be printed. Both \"SQL\" and \"Java\" styles of system view name are supported (e.g. SQL_TABLES and sql.tables will be handled similarly).");
        params.put(SystemViewCommandArg.NODE_ID + " node_id", "ID of the node to get the system view from (deprecated. Use " + SystemViewCommandArg.NODE_IDS + " instead). If not set, random node will be chosen.");
        params.put(SystemViewCommandArg.NODE_IDS + " nodeId1,nodeId2,..", "Comma-separated list of nodes IDs to get the system view from. If not set, random node will be chosen.");
        params.put(SystemViewCommandArg.ALL_NODES.argName(), "Get the system view from all nodes. If not set, random node will be chosen.");
        this.usage(log, "Print system view content:", CommandList.SYSTEM_VIEW, params, "system_view_name", CommandLogger.or(CommandLogger.optional(SystemViewCommandArg.NODE_ID, "node_id"), CommandLogger.optional(SystemViewCommandArg.NODE_IDS, "nodeId1,nodeId2,.."), CommandLogger.optional(SystemViewCommandArg.ALL_NODES)));
    }

    @Override
    public String name() {
        return CommandList.SYSTEM_VIEW.toCommandName();
    }
}

