/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotTaskResult;

public abstract class SnapshotSubcommand
extends AbstractCommand<Object> {
    protected static final String SNAPSHOT_NAME_ARG = "snapshot_name";
    protected Object cmdArg;
    private final String name;
    private final Class<?> taskCls;

    protected SnapshotSubcommand(String name, Class<?> taskCls) {
        this.name = name;
        this.taskCls = taskCls;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            VisorSnapshotTaskResult taskRes = (VisorSnapshotTaskResult)TaskExecutor.executeTaskByNameOnNode(client, this.taskCls.getName(), this.arg(), null, clientCfg);
            this.printResult(taskRes.result(), log);
            Object object = taskRes.result();
            return object;
        }
    }

    @Override
    public Object arg() {
        return this.cmdArg;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.cmdArg = argIter.nextArg("Expected snapshot name.");
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected argument: " + argIter.peekNextArg() + '.');
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    protected Map<String, String> generalUsageOptions() {
        return F.asMap((Object)SNAPSHOT_NAME_ARG, (Object)"Snapshot name. In case incremental snapshot (--incremental) full snapshot name must be provided.");
    }

    protected void printResult(Object res, IgniteLogger log) {
        log.info(String.valueOf(res));
    }
}

