/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommands;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommand;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T5;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotStatusTask;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;

public class SnapshotStatusCommand
extends SnapshotSubcommand {
    protected SnapshotStatusCommand() {
        super("status", VisorSnapshotStatusTask.class);
    }

    @Override
    protected void printResult(Object res, IgniteLogger log) {
        if (res == null) {
            log.info("There is no create or restore snapshot operation in progress.");
            return;
        }
        VisorSnapshotStatusTask.SnapshotStatus status = (VisorSnapshotStatusTask.SnapshotStatus)res;
        boolean isCreating = status.operation() == VisorSnapshotStatusTask.SnapshotOperation.CREATE;
        boolean isIncremental = status.incrementIndex() > 0;
        GridStringBuilder s = new GridStringBuilder();
        if (isCreating) {
            s.a("Create snapshot operation is in progress.").nl();
        } else {
            s.a("Restore snapshot operation is in progress.").nl();
        }
        s.a("Snapshot name: ").a(status.name()).nl();
        s.a("Incremental: ").a(isIncremental).nl();
        if (isIncremental) {
            s.a("Increment index: ").a(status.incrementIndex()).nl();
        }
        s.a("Operation request ID: ").a(status.requestId()).nl();
        s.a("Started at: ").a(DateFormat.getDateTimeInstance().format(new Date(status.startTime()))).nl();
        s.a("Duration: ").a(X.timeSpan2DHMSM((long)(System.currentTimeMillis() - status.startTime()))).nl().nl();
        s.a("Estimated operation progress:").nl();
        log.info(s.toString());
        SnapshotTaskProgressDesc desc = isCreating && isIncremental ? new CreateIncrementalSnapshotTaskProgressDesc() : (isCreating ? new CreateFullSnapshotTaskProgressDesc() : (isIncremental ? new RestoreIncrementalSnapshotTaskProgressDesc() : new RestoreFullSnapshotTaskProgressDesc()));
        List<List<?>> rows = status.progress().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> desc.buildRow((UUID)e.getKey(), (T5<Long, Long, Long, Long, Long>)((T5)e.getValue()))).collect(Collectors.toList());
        SystemViewCommand.printTable(desc.titles(), desc.types(), rows, log);
        log.info(U.nl());
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected argument: " + argIter.peekNextArg() + '.');
        }
    }

    @Override
    public void printUsage(IgniteLogger log) {
        this.usage(log, "Get the status of the current snapshot operation:", CommandList.SNAPSHOT, SnapshotSubcommands.STATUS.toString());
    }

    private static class RestoreIncrementalSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        RestoreIncrementalSnapshotTaskProgressDesc() {
            super(F.asList((Object[])new String[]{"Node ID", "Processed, partitions", "Total, partitions", "Percent", "Processed, WAL segments", "Total, WAL segments", "Percent", "Processed, WAL entries"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(nodeId);
            long processedParts = (Long)progress.get1();
            long totalParts = (Long)progress.get2();
            if (totalParts <= 0L) {
                result.addAll(F.asList((Object[])new String[]{"unknown", "unknown", "unknown"}));
            } else {
                String partsPercent = (int)(processedParts * 100L / totalParts) + "%";
                result.add(F.asList((Object[])new Serializable[]{Long.valueOf(processedParts), Long.valueOf(totalParts), partsPercent}));
            }
            long processedWalSegs = (Long)progress.get3();
            long totalWalSegs = (Long)progress.get4();
            if (processedWalSegs <= 0L) {
                result.addAll(F.asList((Object[])new String[]{"unknown", "unknown", "unknown"}));
            } else {
                String walSegsPercent = (int)(processedWalSegs * 100L / totalWalSegs) + "%";
                result.add(F.asList((Object[])new Serializable[]{Long.valueOf(processedWalSegs), Long.valueOf(totalWalSegs), walSegsPercent}));
            }
            long processedWalEntries = (Long)progress.get5();
            if (processedWalEntries <= 0L) {
                result.add("unknown");
            } else {
                result.add(processedWalEntries);
            }
            return result;
        }
    }

    private static class RestoreFullSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        RestoreFullSnapshotTaskProgressDesc() {
            super(F.asList((Object[])new String[]{"Node ID", "Processed, partitions", "Total, partitions", "Percent"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            long processed = (Long)progress.get1();
            long total = (Long)progress.get2();
            if (total <= 0L) {
                return F.asList((Object[])new Serializable[]{nodeId, "unknown", "unknown", "unknown"});
            }
            String percent = (int)(processed * 100L / total) + "%";
            return F.asList((Object[])new Serializable[]{nodeId, Long.valueOf(processed), Long.valueOf(total), percent});
        }
    }

    private static class CreateIncrementalSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        CreateIncrementalSnapshotTaskProgressDesc() {
            super(F.asList((Object[])new String[]{"Node ID", "Progress"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            return F.asList((Object[])new Serializable[]{nodeId, "unknown"});
        }
    }

    private static class CreateFullSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        CreateFullSnapshotTaskProgressDesc() {
            super(F.asList((Object[])new String[]{"Node ID", "Processed, bytes", "Total, bytes", "Percent"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            long processed = (Long)progress.get1();
            long total = (Long)progress.get2();
            if (total <= 0L) {
                return F.asList((Object[])new Serializable[]{nodeId, "unknown", "unknown", "unknown"});
            }
            String percent = (int)(processed * 100L / total) + "%";
            return F.asList((Object[])new Serializable[]{nodeId, U.humanReadableByteCount((long)processed), U.humanReadableByteCount((long)total), percent});
        }
    }

    private static abstract class SnapshotTaskProgressDesc {
        private final List<String> titles;

        SnapshotTaskProgressDesc(List<String> titles) {
            this.titles = Collections.unmodifiableList(titles);
        }

        List<String> titles() {
            return this.titles;
        }

        List<VisorSystemViewTask.SimpleType> types() {
            ArrayList<VisorSystemViewTask.SimpleType> types = new ArrayList<VisorSystemViewTask.SimpleType>();
            types.add(VisorSystemViewTask.SimpleType.STRING);
            for (int i = 0; i < this.titles().size() - 1; ++i) {
                types.add(VisorSystemViewTask.SimpleType.NUMBER);
            }
            return types;
        }

        abstract List<?> buildRow(UUID var1, T5<Long, Long, Long, Long, Long> var2);
    }
}

