/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.snapshot.SnapshotRestoreCommandOption;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommands;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskAction;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskArg;

public class SnapshotRestoreCommand
extends SnapshotSubcommand {
    protected SnapshotRestoreCommand() {
        super("restore", VisorSnapshotRestoreTask.class);
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        this.explainDeprecatedOptions(this.cmdArg, log);
        return super.execute(clientCfg, log);
    }

    private void explainDeprecatedOptions(Object cmdArg, IgniteLogger log) {
        VisorSnapshotRestoreTaskAction action = ((VisorSnapshotRestoreTaskArg)cmdArg).jobAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case START: {
                log.warning("Command option '--" + VisorSnapshotRestoreTaskAction.START.toString().toLowerCase() + "' is redundant and must be avoided.");
                break;
            }
            case CANCEL: {
                log.warning("Command deprecated. Use `" + (Object)((Object)CommandList.SNAPSHOT) + ' ' + (Object)((Object)SnapshotSubcommands.CANCEL) + "' instead.");
                break;
            }
            case STATUS: {
                log.warning("Command deprecated. Use '" + (Object)((Object)CommandList.SNAPSHOT) + ' ' + (Object)((Object)SnapshotSubcommands.STATUS) + "' instead.");
            }
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String snpName = argIter.nextArg("Expected snapshot name.");
        VisorSnapshotRestoreTaskAction restoreAction = this.parseAction(argIter.peekNextArg());
        String snpPath = null;
        Integer incIdx = null;
        Set<String> grpNames = null;
        boolean sync = false;
        boolean check = false;
        if (restoreAction != null) {
            argIter.nextArg(null);
        }
        while (argIter.hasNextSubArg()) {
            String errMsg;
            String arg = argIter.nextArg(null);
            if (restoreAction != null && restoreAction != VisorSnapshotRestoreTaskAction.START) {
                throw new IllegalArgumentException("Invalid argument: " + arg + ". Action \"--" + restoreAction.name().toLowerCase() + "\" does not support specified option.");
            }
            SnapshotRestoreCommandOption option = CommandArgUtils.of(arg, SnapshotRestoreCommandOption.class);
            if (option == null) {
                throw new IllegalArgumentException("Invalid argument: " + arg + ". Possible options: " + F.concat((Iterable)F.asList((Object[])SnapshotRestoreCommandOption.values()), (String)", ") + '.');
            }
            if (option == SnapshotRestoreCommandOption.GROUPS) {
                if (grpNames != null) {
                    throw new IllegalArgumentException(SnapshotRestoreCommandOption.GROUPS.argName() + " arg specified twice.");
                }
                String argDesc = "a comma-separated list of cache group names.";
                grpNames = argIter.nextStringSet(argDesc);
                if (!grpNames.isEmpty()) continue;
                throw new IllegalArgumentException("Expected " + argDesc);
            }
            if (option == SnapshotRestoreCommandOption.SOURCE) {
                if (snpPath != null) {
                    throw new IllegalArgumentException(SnapshotRestoreCommandOption.SOURCE.argName() + " arg specified twice.");
                }
                errMsg = "Expected path to the snapshot directory.";
                if (CommandArgIterator.isCommandOrOption(argIter.peekNextArg())) {
                    throw new IllegalArgumentException(errMsg);
                }
                snpPath = argIter.nextArg(errMsg);
                continue;
            }
            if (option == SnapshotRestoreCommandOption.INCREMENT) {
                if (incIdx != null) {
                    throw new IllegalArgumentException(SnapshotRestoreCommandOption.INCREMENT.argName() + " arg specified twice.");
                }
                errMsg = "incremental snapshot index";
                if (CommandArgIterator.isCommandOrOption(argIter.peekNextArg())) {
                    throw new IllegalArgumentException("Expected " + errMsg + '.');
                }
                incIdx = argIter.nextIntArg(errMsg);
                continue;
            }
            if (option == SnapshotRestoreCommandOption.SYNC) {
                if (sync) {
                    throw new IllegalArgumentException(SnapshotRestoreCommandOption.SYNC.argName() + " arg specified twice.");
                }
                sync = true;
                continue;
            }
            if (option != SnapshotRestoreCommandOption.CHECK) continue;
            if (check) {
                throw new IllegalArgumentException(SnapshotRestoreCommandOption.CHECK.argName() + " arg specified twice.");
            }
            check = true;
        }
        this.cmdArg = new VisorSnapshotRestoreTaskArg(snpName, snpPath, incIdx, sync, restoreAction, grpNames, check);
    }

    @Override
    public void printUsage(IgniteLogger log) {
        Map<String, String> params = this.generalUsageOptions();
        LinkedHashMap<String, String> startParams = new LinkedHashMap<String, String>(params);
        startParams.put(SnapshotRestoreCommandOption.GROUPS.argName() + " " + SnapshotRestoreCommandOption.GROUPS.arg(), SnapshotRestoreCommandOption.GROUPS.description());
        startParams.put(SnapshotRestoreCommandOption.SOURCE.argName() + " " + SnapshotRestoreCommandOption.SOURCE.arg(), SnapshotRestoreCommandOption.SOURCE.description());
        startParams.put(SnapshotRestoreCommandOption.INCREMENT.argName() + " " + SnapshotRestoreCommandOption.INCREMENT.arg(), SnapshotRestoreCommandOption.INCREMENT.description());
        startParams.put(SnapshotRestoreCommandOption.SYNC.argName(), SnapshotRestoreCommandOption.SYNC.description());
        startParams.put(SnapshotRestoreCommandOption.CHECK.argName(), SnapshotRestoreCommandOption.CHECK.description());
        this.usage(log, "Restore snapshot:", CommandList.SNAPSHOT, startParams, SnapshotSubcommands.RESTORE.toString(), "snapshot_name", CommandLogger.optional(SnapshotRestoreCommandOption.INCREMENT.argName(), SnapshotRestoreCommandOption.INCREMENT.arg()), CommandLogger.optional(SnapshotRestoreCommandOption.GROUPS.argName(), SnapshotRestoreCommandOption.GROUPS.arg()), CommandLogger.optional(SnapshotRestoreCommandOption.SOURCE.argName(), SnapshotRestoreCommandOption.SOURCE.arg()), CommandLogger.optional(SnapshotRestoreCommandOption.SYNC.argName()), CommandLogger.optional(SnapshotRestoreCommandOption.CHECK.argName()));
        this.usage(log, "Snapshot restore operation status (Command deprecated. Use '" + (Object)((Object)CommandList.SNAPSHOT) + ' ' + (Object)((Object)SnapshotSubcommands.STATUS) + "' instead):", CommandList.SNAPSHOT, params, SnapshotSubcommands.RESTORE.toString(), "snapshot_name", "--status");
        this.usage(log, "Cancel snapshot restore operation (Command deprecated. Use '" + (Object)((Object)CommandList.SNAPSHOT) + ' ' + (Object)((Object)SnapshotSubcommands.CANCEL) + "' instead):", CommandList.SNAPSHOT, params, SnapshotSubcommands.RESTORE.toString(), "snapshot_name", "--cancel");
    }

    @Override
    public String confirmationPrompt() {
        VisorSnapshotRestoreTaskArg arg = (VisorSnapshotRestoreTaskArg)this.cmdArg;
        return arg.jobAction() != null && arg.jobAction() != VisorSnapshotRestoreTaskAction.START || arg.groupNames() != null ? null : "Warning: command will restore ALL USER-CREATED CACHE GROUPS from the snapshot " + arg.snapshotName() + '.';
    }

    private VisorSnapshotRestoreTaskAction parseAction(String arg) {
        if (arg == null) {
            return null;
        }
        for (VisorSnapshotRestoreTaskAction val : VisorSnapshotRestoreTaskAction.values()) {
            if (!arg.toLowerCase().equals("--" + val.name().toLowerCase())) continue;
            return val;
        }
        return null;
    }
}

