/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.LinkedHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.snapshot.SnapshotCreateCommandOption;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCreateTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCreateTaskArg;

public class SnapshotCreateCommand
extends SnapshotSubcommand {
    protected SnapshotCreateCommand() {
        super("create", VisorSnapshotCreateTask.class);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String snpName = argIter.nextArg("Expected snapshot name.");
        String snpPath = null;
        boolean sync = false;
        boolean incremental = false;
        while (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg(null);
            SnapshotCreateCommandOption option = CommandArgUtils.of(arg, SnapshotCreateCommandOption.class);
            if (option == null) {
                throw new IllegalArgumentException("Invalid argument: " + arg + ". Possible options: " + F.concat((Iterable)F.asList((Object[])SnapshotCreateCommandOption.values()), (String)", ") + '.');
            }
            if (option == SnapshotCreateCommandOption.DESTINATION) {
                if (snpPath != null) {
                    throw new IllegalArgumentException(SnapshotCreateCommandOption.DESTINATION.argName() + " arg specified twice.");
                }
                String errMsg = "Expected path to the snapshot directory.";
                if (CommandArgIterator.isCommandOrOption(argIter.peekNextArg())) {
                    throw new IllegalArgumentException(errMsg);
                }
                snpPath = argIter.nextArg(errMsg);
                continue;
            }
            if (option == SnapshotCreateCommandOption.SYNC) {
                if (sync) {
                    throw new IllegalArgumentException(SnapshotCreateCommandOption.SYNC.argName() + " arg specified twice.");
                }
                sync = true;
                continue;
            }
            if (option != SnapshotCreateCommandOption.INCREMENTAL) continue;
            if (incremental) {
                throw new IllegalArgumentException(SnapshotCreateCommandOption.INCREMENTAL.argName() + " arg specified twice.");
            }
            incremental = true;
        }
        this.cmdArg = new VisorSnapshotCreateTaskArg(snpName, snpPath, sync, incremental, false);
    }

    @Override
    public void printUsage(IgniteLogger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.generalUsageOptions());
        params.put(SnapshotCreateCommandOption.DESTINATION.argName() + " " + SnapshotCreateCommandOption.DESTINATION.arg(), SnapshotCreateCommandOption.DESTINATION.description());
        params.put(SnapshotCreateCommandOption.SYNC.argName(), SnapshotCreateCommandOption.SYNC.description());
        params.put(SnapshotCreateCommandOption.INCREMENTAL.argName(), SnapshotCreateCommandOption.INCREMENTAL.description());
        this.usage(log, "Create cluster snapshot:", CommandList.SNAPSHOT, params, this.name(), "snapshot_name", CommandLogger.optional(SnapshotCreateCommandOption.DESTINATION.argName(), SnapshotCreateCommandOption.DESTINATION.arg()), CommandLogger.optional(SnapshotCreateCommandOption.SYNC.argName()), CommandLogger.optional(SnapshotCreateCommandOption.INCREMENTAL.argName()));
    }
}

