/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.LinkedHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.snapshot.SnapshotCheckCommandOption;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCheckTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCheckTaskArg;

public class SnapshotCheckCommand
extends SnapshotSubcommand {
    protected SnapshotCheckCommand() {
        super("check", VisorSnapshotCheckTask.class);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String snpName = argIter.nextArg("Expected snapshot name.");
        String snpPath = null;
        Integer incIdx = null;
        while (argIter.hasNextSubArg()) {
            String errMsg;
            String arg = argIter.nextArg(null);
            SnapshotCheckCommandOption option = CommandArgUtils.of(arg, SnapshotCheckCommandOption.class);
            if (option == null) {
                throw new IllegalArgumentException("Invalid argument: " + arg + ". Possible options: " + F.concat((Iterable)F.asList((Object[])SnapshotCheckCommandOption.values()), (String)", ") + '.');
            }
            if (option == SnapshotCheckCommandOption.SOURCE) {
                if (snpPath != null) {
                    throw new IllegalArgumentException(SnapshotCheckCommandOption.SOURCE.argName() + " arg specified twice.");
                }
                errMsg = "Expected path to the snapshot directory.";
                if (CommandArgIterator.isCommandOrOption(argIter.peekNextArg())) {
                    throw new IllegalArgumentException(errMsg);
                }
                snpPath = argIter.nextArg(errMsg);
                continue;
            }
            if (option != SnapshotCheckCommandOption.INCREMENT) continue;
            if (incIdx != null) {
                throw new IllegalArgumentException(SnapshotCheckCommandOption.INCREMENT.argName() + " arg specified twice.");
            }
            errMsg = "incremental snapshot index.";
            if (CommandArgIterator.isCommandOrOption(argIter.peekNextArg())) {
                throw new IllegalArgumentException("Expected " + errMsg);
            }
            incIdx = argIter.nextIntArg(errMsg);
        }
        this.cmdArg = new VisorSnapshotCheckTaskArg(snpName, snpPath, incIdx == null ? 0 : incIdx);
    }

    @Override
    public void printUsage(IgniteLogger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.generalUsageOptions());
        params.put(SnapshotCheckCommandOption.SOURCE.argName() + " " + SnapshotCheckCommandOption.SOURCE.arg(), SnapshotCheckCommandOption.SOURCE.description());
        params.put(SnapshotCheckCommandOption.INCREMENT.argName() + " " + SnapshotCheckCommandOption.INCREMENT.arg(), SnapshotCheckCommandOption.INCREMENT.description());
        this.usage(log, "Check snapshot:", CommandList.SNAPSHOT, params, this.name(), "snapshot_name", CommandLogger.optional(SnapshotCheckCommandOption.SOURCE.argName(), SnapshotCheckCommandOption.SOURCE.arg()), CommandLogger.optional(SnapshotCheckCommandOption.INCREMENT.argName(), SnapshotCheckCommandOption.INCREMENT.arg()));
    }

    @Override
    protected void printResult(Object res, IgniteLogger log) {
        ((SnapshotPartitionsVerifyTaskResult)res).print(arg_0 -> ((IgniteLogger)log).info(arg_0));
    }
}

