/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.snapshot.SnapshotCancelCommandOption;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCancelTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCancelTaskArg;

public class SnapshotCancelCommand
extends SnapshotSubcommand {
    protected SnapshotCancelCommand() {
        super("cancel", VisorSnapshotCancelTask.class);
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        if (!F.isEmpty((String)((VisorSnapshotCancelTaskArg)this.cmdArg).snapshotName())) {
            log.warning("'" + SnapshotCancelCommandOption.NAME.arg() + "' option is deprecated, please use operation request ID to cancel operation.");
        }
        return super.execute(clientCfg, log);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        UUID reqId = null;
        String snpName = null;
        String explainMsg = "One of " + Arrays.toString(SnapshotCancelCommandOption.values()) + " is expected.";
        String arg = argIter.nextArg(explainMsg);
        if (arg.equals(SnapshotCancelCommandOption.ID.argName())) {
            reqId = UUID.fromString(argIter.nextArg("Expected operation request ID."));
        } else if (arg.equals(SnapshotCancelCommandOption.NAME.argName())) {
            snpName = argIter.nextArg("Expected snapshot name.");
        } else {
            throw new IllegalArgumentException("Unexpected argument: " + argIter.peekNextArg() + ". " + explainMsg);
        }
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("No more arguments expected.");
        }
        this.cmdArg = new VisorSnapshotCancelTaskArg(reqId, snpName);
    }

    @Override
    public void printUsage(IgniteLogger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(SnapshotCancelCommandOption.ID.argName() + " " + SnapshotCancelCommandOption.ID.arg(), SnapshotCancelCommandOption.ID.description());
        params.put(SnapshotCancelCommandOption.NAME.argName() + " " + SnapshotCancelCommandOption.NAME.arg(), SnapshotCancelCommandOption.NAME.description());
        this.usage(log, "Cancel running snapshot operation:", CommandList.SNAPSHOT, params, this.name(), CommandLogger.or(SnapshotCancelCommandOption.ID.argName() + " " + SnapshotCancelCommandOption.ID.arg(), SnapshotCancelCommandOption.NAME.argName() + " " + SnapshotCancelCommandOption.NAME.arg()));
    }
}

