/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.query.KillSubcommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.visor.client.VisorClientConnectionDropTask;
import org.apache.ignite.internal.visor.compute.VisorComputeCancelSessionTask;
import org.apache.ignite.internal.visor.compute.VisorComputeCancelSessionTaskArg;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyCancelTask;
import org.apache.ignite.internal.visor.query.VisorContinuousQueryCancelTask;
import org.apache.ignite.internal.visor.query.VisorContinuousQueryCancelTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryCancelOnInitiatorTask;
import org.apache.ignite.internal.visor.query.VisorQueryCancelOnInitiatorTaskArg;
import org.apache.ignite.internal.visor.query.VisorScanQueryCancelTask;
import org.apache.ignite.internal.visor.query.VisorScanQueryCancelTaskArg;
import org.apache.ignite.internal.visor.service.VisorCancelServiceTask;
import org.apache.ignite.internal.visor.service.VisorCancelServiceTaskArg;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCancelTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCancelTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxTask;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.lang.IgniteUuid;

public class KillCommand
extends AbstractCommand<Object> {
    private Object taskArgs;
    private String taskName;
    private UUID nodeId;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Object r = TaskExecutor.executeTaskByNameOnNode(client, this.taskName, this.taskArgs, this.nodeId, clientCfg);
            return r;
        }
        catch (Throwable e) {
            log.error("Failed to perform operation.");
            log.error(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public Object arg() {
        return this.taskArgs;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        KillSubcommand cmd;
        try {
            cmd = KillSubcommand.valueOf(argIter.nextArg("Expected type of resource to kill.").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected type of resource to kill.");
        }
        switch (cmd) {
            case COMPUTE: {
                this.taskArgs = new VisorComputeCancelSessionTaskArg(IgniteUuid.fromString((String)argIter.nextArg("Expected compute task id.")));
                this.taskName = VisorComputeCancelSessionTask.class.getName();
                this.nodeId = null;
                break;
            }
            case SERVICE: {
                this.taskArgs = new VisorCancelServiceTaskArg(argIter.nextArg("Expected service name."));
                this.taskName = VisorCancelServiceTask.class.getName();
                this.nodeId = null;
                break;
            }
            case TRANSACTION: {
                String xid = argIter.nextArg("Expected transaction id.");
                this.taskArgs = new VisorTxTaskArg(VisorTxOperation.KILL, null, null, null, null, null, null, xid, null, null, null);
                this.taskName = VisorTxTask.class.getName();
                this.nodeId = null;
                break;
            }
            case SQL: {
                T2 ids = SqlKillQueryCommand.parseGlobalQueryId((String)argIter.nextArg("Expected SQL query id."));
                if (ids == null) {
                    throw new IllegalArgumentException("Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
                }
                this.taskArgs = new VisorQueryCancelOnInitiatorTaskArg((UUID)ids.get1(), ((Long)ids.get2()).longValue());
                this.taskName = VisorQueryCancelOnInitiatorTask.class.getName();
                this.nodeId = null;
                break;
            }
            case SCAN: {
                String originNodeIsStr = argIter.nextArg("Expected query originating node id.");
                UUID originNodeId = UUID.fromString(originNodeIsStr);
                String cacheName = argIter.nextArg("Expected cache name.");
                long qryId = Long.parseLong(argIter.nextArg("Expected query identifier."));
                this.taskArgs = new VisorScanQueryCancelTaskArg(originNodeId, cacheName, qryId);
                this.taskName = VisorScanQueryCancelTask.class.getName();
                this.nodeId = null;
                break;
            }
            case CONTINUOUS: {
                this.taskArgs = new VisorContinuousQueryCancelTaskArg(UUID.fromString(argIter.nextArg("Expected query originating node id.")), UUID.fromString(argIter.nextArg("Expected continuous query id.")));
                this.taskName = VisorContinuousQueryCancelTask.class.getName();
                this.nodeId = null;
                break;
            }
            case SNAPSHOT: {
                String arg = argIter.nextArg("Expected snapshot operation request ID.");
                this.taskArgs = new VisorSnapshotCancelTaskArg(UUID.fromString(arg), null);
                this.taskName = VisorSnapshotCancelTask.class.getName();
                this.nodeId = null;
                break;
            }
            case CONSISTENCY: {
                this.taskName = VisorConsistencyCancelTask.class.getName();
                this.taskArgs = null;
                this.nodeId = TaskExecutor.BROADCAST_UUID;
                break;
            }
            case CLIENT: {
                this.taskName = VisorClientConnectionDropTask.class.getName();
                String argVal = argIter.nextArg("connection id");
                Object object = this.taskArgs = "ALL".equals(argVal) ? null : Long.valueOf(Long.parseLong(argVal));
                if ("--node-id".equals(argIter.peekNextArg())) {
                    argIter.nextArg("--node-id");
                    this.nodeId = UUID.fromString(argIter.nextArg("node_id"));
                    break;
                }
                this.nodeId = TaskExecutor.BROADCAST_UUID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown kill subcommand: " + (Object)((Object)cmd));
            }
        }
    }

    @Override
    public void printUsage(IgniteLogger log) {
        this.usage(log, "Kill compute task by session id:", CommandList.KILL, Collections.singletonMap("session_id", "Session identifier."), KillSubcommand.COMPUTE.toString(), "session_id");
        this.usage(log, "Kill service by name:", CommandList.KILL, Collections.singletonMap("name", "Service name."), KillSubcommand.SERVICE.toString(), "name");
        this.usage(log, "Kill transaction by xid:", CommandList.KILL, Collections.singletonMap("xid", "Transaction identifier."), KillSubcommand.TRANSACTION.toString(), "xid");
        this.usage(log, "Kill sql query by query id:", CommandList.KILL, Collections.singletonMap("query_id", "Query identifier."), KillSubcommand.SQL.toString(), "query_id");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("origin_node_id", "Originating node id.");
        params.put("cache_name", "Cache name.");
        params.put("query_id", "Query identifier.");
        this.usage(log, "Kill scan query by node id, cache name and query id:", CommandList.KILL, params, KillSubcommand.SCAN.toString(), "origin_node_id", "cache_name", "query_id");
        params.clear();
        params.put("origin_node_id", "Originating node id.");
        params.put("routine_id", "Routine identifier.");
        this.usage(log, "Kill continuous query by routine id:", CommandList.KILL, params, KillSubcommand.CONTINUOUS.toString(), "origin_node_id", "routine_id");
        params.clear();
        params.put("connection_id", "Connection identifier or ALL.");
        params.put("--node-id node_id", "Node id to drop connection from.");
        this.usage(log, "Kill client connection by id:", CommandList.KILL, params, KillSubcommand.CLIENT.toString(), "connection_id", CommandLogger.optional("--node-id node_id"));
        this.usage(log, "Kill running snapshot by snapshot name:", CommandList.KILL, Collections.singletonMap("snapshot_name", "Snapshot name."), KillSubcommand.SNAPSHOT.toString(), "snapshot_name");
    }

    @Override
    public String name() {
        return CommandList.KILL.toCommandName();
    }
}

