/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.property;

import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.property.subcommands.PropertyGetCommand;
import org.apache.ignite.internal.commandline.property.subcommands.PropertyHelpCommand;
import org.apache.ignite.internal.commandline.property.subcommands.PropertyListCommand;
import org.apache.ignite.internal.commandline.property.subcommands.PropertySetCommand;

public enum PropertySubCommandsList {
    HELP("help", new PropertyHelpCommand()),
    LIST("list", new PropertyListCommand()),
    GET("get", new PropertyGetCommand()),
    SET("set", new PropertySetCommand());

    private final String name;
    private final Command<?> cmd;

    private PropertySubCommandsList(String name, Command<?> cmd) {
        this.name = name;
        this.cmd = cmd;
    }

    public String text() {
        return this.name;
    }

    public Command<?> command() {
        return this.cmd;
    }

    public static PropertySubCommandsList parse(String name) {
        for (PropertySubCommandsList cmd : PropertySubCommandsList.values()) {
            if (!cmd.name.equalsIgnoreCase(name)) continue;
            return cmd;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

