/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.property;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.property.PropertySubCommandsList;

public class PropertyCommand
extends AbstractCommand<Object> {
    private Command<?> delegate;

    @Override
    public void printUsage(IgniteLogger log) {
        this.usage(log, "Print property command help:", CommandList.PROPERTY, PropertySubCommandsList.HELP.toString());
        this.usage(log, "Print list of available properties:", CommandList.PROPERTY, PropertySubCommandsList.LIST.toString());
        this.usage(log, "Get the property value:", CommandList.PROPERTY, PropertySubCommandsList.GET.toString(), "--name", "<property_name>");
        this.usage(log, "Set the property value:", CommandList.PROPERTY, PropertySubCommandsList.SET.toString(), "--name", "<property_name>", "--val", "<property_value>");
    }

    @Override
    public String name() {
        return CommandList.PROPERTY.toCommandName();
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        PropertySubCommandsList subcommand = PropertySubCommandsList.parse(argIter.nextArg("Expected property action."));
        if (subcommand == null) {
            throw new IllegalArgumentException("Expected correct property action.");
        }
        this.delegate = subcommand.command();
        this.delegate.parseArguments(argIter);
    }

    @Override
    public String confirmationPrompt() {
        return this.delegate != null ? this.delegate.confirmationPrompt() : null;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        return this.delegate.execute(clientCfg, log);
    }

    @Override
    public Object arg() {
        return this.delegate.arg();
    }
}

