/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.metric;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.metric.MetricCommandArg;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.metric.VisorMetricTask;
import org.apache.ignite.internal.visor.metric.VisorMetricTaskArg;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;

public class MetricCommand
extends AbstractCommand<VisorMetricTaskArg> {
    private VisorMetricTaskArg taskArg;
    private UUID nodeId;

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try {
            Map res;
            try (GridClient client = Command.startClient(clientCfg);){
                res = (Map)TaskExecutor.executeTaskByNameOnNode(client, VisorMetricTask.class.getName(), this.taskArg, this.nodeId, clientCfg);
            }
            if (res != null) {
                List<List<?>> data = res.entrySet().stream().map(entry -> Arrays.asList(entry.getKey(), entry.getValue())).collect(Collectors.toList());
                SystemViewCommand.printTable(Arrays.asList("metric", "value"), Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.STRING), data, log);
            } else if (this.arg().bounds() == null && this.arg().rateTimeInterval() < 0L) {
                log.info("No metric with specified name was found [name=" + this.taskArg.name() + "]");
            }
            return res;
        }
        catch (Throwable e) {
            log.error("Failed to perform operation.");
            log.error(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.nodeId = null;
        String metricName = null;
        Object val = null;
        boolean configureHistogram = false;
        while (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg("Failed to read command argument.");
            MetricCommandArg cmdArg = CommandArgUtils.of(arg, MetricCommandArg.class);
            if (cmdArg == MetricCommandArg.NODE_ID) {
                this.nodeId = argIter.nextUuidArg(MetricCommandArg.NODE_ID.argName());
                continue;
            }
            if (cmdArg == MetricCommandArg.CONFIGURE_HISTOGRAM || cmdArg == MetricCommandArg.CONFIGURE_HITRATE) {
                if (metricName != null) {
                    throw new IllegalArgumentException("One of " + MetricCommandArg.CONFIGURE_HISTOGRAM + ", " + MetricCommandArg.CONFIGURE_HITRATE + " must be specified");
                }
                configureHistogram = cmdArg == MetricCommandArg.CONFIGURE_HISTOGRAM;
                metricName = argIter.nextArg("Name of metric to configure expected");
                if (configureHistogram) {
                    val = Arrays.stream(argIter.nextArg("Comma-separated histogram bounds expected").split(",")).mapToLong(Long::parseLong).toArray();
                    if (F.isSorted((long[])((long[])val))) continue;
                    throw new IllegalArgumentException("Bounds must be sorted");
                }
                val = argIter.nextNonNegativeLongArg("Hitrate time interval");
                if ((Long)val != 0L) continue;
                throw new IllegalArgumentException("Positive value expected");
            }
            if (metricName != null) {
                throw new IllegalArgumentException("Multiple metric(metric registry) names are not supported.");
            }
            metricName = arg;
        }
        if (metricName == null) {
            throw new IllegalArgumentException("The name of a metric(metric registry) is expected.");
        }
        this.taskArg = new VisorMetricTaskArg(metricName, val != null && configureHistogram ? (long[])val : null, val != null && !configureHistogram ? (Long)val : -1L);
    }

    @Override
    public VisorMetricTaskArg arg() {
        return this.taskArg;
    }

    @Override
    public void printUsage(IgniteLogger log) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("node_id", "ID of the node to get the metric values from. If not set, random node will be chosen.");
        params.put("name", "Name of the metric which value should be printed. If name of the metric registry is specified, value of all its metrics will be printed.");
        this.usage(log, "Print metric value:", CommandList.METRIC, params, CommandLogger.optional(MetricCommandArg.NODE_ID, "node_id"), "name");
        params.remove("node_id");
        params.put("name", "Name of the metric which value should be configured.");
        params.put("newBounds", "Comma-separated list of longs to configure histogram.");
        params.put("newRateTimeInterval", "Rate time interval of hitrate.");
        this.usage(log, "Configure metric:", CommandList.METRIC, params, CommandLogger.or(CommandLogger.grouped(MetricCommandArg.CONFIGURE_HISTOGRAM, "name", "newBounds"), CommandLogger.grouped(MetricCommandArg.CONFIGURE_HITRATE, "name", "newRateTimeInterval")));
    }

    @Override
    public String name() {
        return CommandList.METRIC.toCommandName();
    }
}

