/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.meta.MetadataSubCommandsList;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataTypeArgs;

public class MetadataCommand
extends AbstractCommand<Object> {
    private Command<?> delegate;

    @Override
    public void printUsage(IgniteLogger log) {
        this.usage(log, "Print metadata command help:", CommandList.METADATA, MetadataSubCommandsList.HELP.toString());
        this.usage(log, "Print list of binary metadata types:", CommandList.METADATA, MetadataSubCommandsList.LIST.toString());
        this.usage(log, "Print detailed info about specified binary type (the type must be specified by type name or by type identifier):", CommandList.METADATA, MetadataSubCommandsList.DETAILS.toString(), CommandLogger.optional("--typeId", "<typeId>"), CommandLogger.optional("--typeName", "<typeName>"));
        this.usage(log, "Remove the metadata of the specified type (the type must be specified by type name or by type identifier) from cluster and saves the removed metadata to the specified file. \nIf the file name isn't specified the output file name is: '<typeId>.bin'", CommandList.METADATA, MetadataSubCommandsList.REMOVE.toString(), CommandLogger.optional("--typeId", "<typeId>"), CommandLogger.optional("--typeName", "<typeName>"), CommandLogger.optional("--out", "<fileName>"));
        this.usage(log, "Update cluster metadata from specified file (file name is required)", CommandList.METADATA, MetadataSubCommandsList.UPDATE.toString(), "--in", "<fileName>");
    }

    @Override
    public String name() {
        return CommandList.METADATA.toCommandName();
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        MetadataSubCommandsList subcommand = MetadataSubCommandsList.parse(argIter.nextArg("Expected metadata action."));
        if (subcommand == null) {
            throw new IllegalArgumentException("Expected correct metadata action.");
        }
        this.delegate = subcommand.command();
        this.delegate.parseArguments(argIter);
    }

    @Override
    public boolean experimental() {
        return true;
    }

    @Override
    public String confirmationPrompt() {
        return this.delegate != null ? this.delegate.confirmationPrompt() : null;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        return this.delegate.execute(clientCfg, log);
    }

    @Override
    public Object arg() {
        return this.delegate.arg();
    }

    public static MetadataTypeArgs parseArgs(CommandArgIterator argIter) {
        String typeName = null;
        Integer typeId = null;
        while (argIter.hasNextSubArg() && typeName == null && typeId == null) {
            String optName;
            switch (optName = argIter.nextArg("Expecting --typeName or --typeId")) {
                case "--typeName": {
                    typeName = argIter.nextArg("type name");
                    break;
                }
                case "--typeId": {
                    typeId = argIter.nextIntArg("typeId");
                }
            }
        }
        if (typeName == null && typeId == null) {
            throw new IllegalArgumentException("Type to remove is not specified. Please add one of the options: --typeName <type_name> or --typeId <type_id>");
        }
        return new MetadataTypeArgs(typeName, typeId);
    }
}

