/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommands;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.encryption.VisorCacheGroupEncryptionTaskArg;
import org.apache.ignite.internal.visor.encryption.VisorCacheGroupEncryptionTaskResult;
import org.apache.ignite.internal.visor.encryption.VisorEncryptionKeyIdsTask;
import org.apache.ignite.internal.visor.encryption.VisorReencryptionResumeTask;
import org.apache.ignite.internal.visor.encryption.VisorReencryptionStatusTask;
import org.apache.ignite.internal.visor.encryption.VisorReencryptionSuspendTask;

public abstract class CacheGroupEncryptionCommand<T>
extends AbstractCommand<VisorCacheGroupEncryptionTaskArg> {
    private VisorCacheGroupEncryptionTaskArg taskArg;

    @Override
    public VisorCacheGroupEncryptionTaskArg arg() {
        return this.taskArg;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String grpName = argIter.nextArg("\u0421ache group name is expected.");
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected command argument: " + argIter.peekNextArg());
        }
        this.taskArg = new VisorCacheGroupEncryptionTaskArg(grpName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            VisorCacheGroupEncryptionTaskResult res = (VisorCacheGroupEncryptionTaskResult)TaskExecutor.executeTaskByNameOnNode(client, this.visorTaskName(), this.taskArg, TaskExecutor.BROADCAST_UUID, clientCfg);
            this.printResults(res, this.taskArg.groupName(), log);
            VisorCacheGroupEncryptionTaskResult visorCacheGroupEncryptionTaskResult = res;
            return visorCacheGroupEncryptionTaskResult;
        }
        catch (Throwable e) {
            log.error("Failed to perform operation.");
            log.error(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    protected void printResults(VisorCacheGroupEncryptionTaskResult<T> res, String grpName, IgniteLogger log) {
        Map exceptions = res.exceptions();
        for (Map.Entry entry : exceptions.entrySet()) {
            log.info("  Node " + entry.getKey() + ":");
            log.info(String.format("%sfailed to execute command for the cache group \"%s\": %s.", "    ", grpName, ((IgniteException)entry.getValue()).getMessage()));
        }
        Map results = res.results();
        for (Map.Entry entry : results.entrySet()) {
            log.info("  Node " + entry.getKey() + ":");
            this.printNodeResult(entry.getValue(), grpName, log);
        }
    }

    protected abstract void printNodeResult(T var1, String var2, IgniteLogger var3);

    protected abstract String visorTaskName();

    protected static class ResumeReencryption
    extends CacheGroupEncryptionCommand<Boolean> {
        protected ResumeReencryption() {
        }

        @Override
        protected String visorTaskName() {
            return VisorReencryptionResumeTask.class.getName();
        }

        @Override
        public String name() {
            return EncryptionSubcommands.REENCRYPTION_RESUME.text().toUpperCase();
        }

        @Override
        public void printUsage(IgniteLogger log) {
            this.usage(log, "Resume re-encryption of the cache group:", CommandList.ENCRYPTION, EncryptionSubcommands.REENCRYPTION_RESUME.toString(), "cacheGroupName");
        }

        @Override
        protected void printNodeResult(Boolean success, String grpName, IgniteLogger log) {
            log.info(String.format("%sre-encryption of the cache group \"%s\" has %sbeen resumed.", "    ", grpName, success != false ? "" : "already "));
        }
    }

    protected static class SuspendReencryption
    extends CacheGroupEncryptionCommand<Boolean> {
        protected SuspendReencryption() {
        }

        @Override
        protected String visorTaskName() {
            return VisorReencryptionSuspendTask.class.getName();
        }

        @Override
        public String name() {
            return EncryptionSubcommands.REENCRYPTION_SUSPEND.text().toUpperCase();
        }

        @Override
        public void printUsage(IgniteLogger log) {
            this.usage(log, "Suspend re-encryption of the cache group:", CommandList.ENCRYPTION, EncryptionSubcommands.REENCRYPTION_SUSPEND.toString(), "cacheGroupName");
        }

        @Override
        protected void printNodeResult(Boolean success, String grpName, IgniteLogger log) {
            log.info(String.format("%sre-encryption of the cache group \"%s\" has %sbeen suspended.", "    ", grpName, success != false ? "" : "already "));
        }

        @Override
        protected void printResults(VisorCacheGroupEncryptionTaskResult<Boolean> res, String grpName, IgniteLogger log) {
            super.printResults(res, grpName, log);
            log.info("");
            log.info("Note: the re-encryption suspend status is not persisted, re-encryption will be started automatically after the node is restarted.");
            log.info("");
        }
    }

    protected static class CacheKeyIds
    extends CacheGroupEncryptionCommand<List<Integer>> {
        protected CacheKeyIds() {
        }

        @Override
        protected void printResults(VisorCacheGroupEncryptionTaskResult<List<Integer>> res, String grpName, IgniteLogger log) {
            log.info("Encryption key identifiers for cache: " + grpName);
            super.printResults(res, grpName, log);
        }

        @Override
        protected void printNodeResult(List<Integer> keyIds, String grpName, IgniteLogger log) {
            if (F.isEmpty(keyIds)) {
                log.info("    ---");
                return;
            }
            for (int i = 0; i < keyIds.size(); ++i) {
                log.info("    " + keyIds.get(i) + (i == 0 ? " (active)" : ""));
            }
        }

        @Override
        protected String visorTaskName() {
            return VisorEncryptionKeyIdsTask.class.getName();
        }

        @Override
        public String name() {
            return EncryptionSubcommands.CACHE_GROUP_KEY_IDS.text().toUpperCase();
        }

        @Override
        public void printUsage(IgniteLogger log) {
            this.usage(log, "View encryption key identifiers of the cache group:", CommandList.ENCRYPTION, EncryptionSubcommands.CACHE_GROUP_KEY_IDS.toString(), "cacheGroupName");
        }
    }

    protected static class ReencryptionStatus
    extends CacheGroupEncryptionCommand<Long> {
        protected ReencryptionStatus() {
        }

        @Override
        protected void printNodeResult(Long bytesLeft, String grpName, IgniteLogger log) {
            if (bytesLeft == -1L) {
                log.info("    re-encryption completed or not required");
            } else if (bytesLeft == 0L) {
                log.info("    re-encryption will be completed after the next checkpoint");
            } else {
                log.info(String.format("%s%d KB of data left for re-encryption", "    ", bytesLeft / 1024L));
            }
        }

        @Override
        protected String visorTaskName() {
            return VisorReencryptionStatusTask.class.getName();
        }

        @Override
        public String name() {
            return EncryptionSubcommands.REENCRYPTION_STATUS.text().toUpperCase();
        }

        @Override
        public void printUsage(IgniteLogger log) {
            this.usage(log, "Display re-encryption status of the cache group:", CommandList.ENCRYPTION, EncryptionSubcommands.REENCRYPTION_STATUS.toString(), "cacheGroupName");
        }
    }
}

