/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.diagnostic;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArg;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.diagnostic.DiagnosticSubCommand;
import org.apache.ignite.internal.visor.diagnostic.Operation;
import org.apache.ignite.internal.visor.diagnostic.VisorPageLocksResult;
import org.apache.ignite.internal.visor.diagnostic.VisorPageLocksTask;
import org.apache.ignite.internal.visor.diagnostic.VisorPageLocksTrackerArgs;

public class PageLocksCommand
extends AbstractCommand<Arguments> {
    private Arguments arguments;
    private IgniteLogger logger;

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger logger) throws Exception {
        Map res;
        this.logger = logger;
        Set nodeIds = this.arguments.nodeIds;
        try (GridClient client = Command.startClient(clientCfg);){
            if (this.arguments.allNodes) {
                client.compute().nodes().forEach(n -> {
                    nodeIds.add(String.valueOf(n.consistentId()));
                    nodeIds.add(n.nodeId().toString());
                });
            }
            VisorPageLocksTrackerArgs taskArg = new VisorPageLocksTrackerArgs(this.arguments.op, this.arguments.filePath, nodeIds);
            res = (Map)TaskExecutor.executeTask(client, VisorPageLocksTask.class, taskArg, clientCfg);
        }
        this.printResult(res);
        return res;
    }

    @Override
    public Arguments arg() {
        return this.arguments;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String nextArg;
        PageLocksCommandArg arg;
        Operation op = Operation.DUMP_LOG;
        String path = null;
        boolean allNodes = false;
        HashSet<String> nodeIds = new HashSet<String>();
        block7: while (argIter.hasNextArg() && (arg = CommandArgUtils.of(nextArg = argIter.nextArg(""), PageLocksCommandArg.class)) != null) {
            switch (arg) {
                case DUMP: {
                    op = Operation.DUMP_FILE;
                    continue block7;
                }
                case DUMP_LOG: {
                    op = Operation.DUMP_LOG;
                    continue block7;
                }
                case ALL: {
                    allNodes = true;
                    continue block7;
                }
                case NODES: {
                    nodeIds.addAll(argIter.nextStringSet(""));
                    continue block7;
                }
                case PATH: {
                    path = argIter.nextArg("");
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unexpected argumetn:" + arg + ", supported:" + Arrays.toString(PageLocksCommandArg.values()));
        }
        this.arguments = new Arguments(op, path, allNodes, nodeIds);
    }

    @Override
    public void printUsage(IgniteLogger logger) {
        logger.info("View pages locks state information on the node or nodes.");
        logger.info(CommandLogger.join(" ", new Object[]{"control.(sh|bat)", CommandList.DIAGNOSTIC, DiagnosticSubCommand.PAGE_LOCKS, PageLocksCommandArg.DUMP, CommandLogger.optional(PageLocksCommandArg.PATH, "path_to_directory"), CommandLogger.optional(PageLocksCommandArg.ALL), CommandLogger.optional(CommandLogger.or(PageLocksCommandArg.NODES, "nodeId1,nodeId2,..")), CommandLogger.optional(CommandLogger.or(PageLocksCommandArg.NODES, "consistentId1,consistentId2,..")), "// Save page locks dump to file generated in IGNITE_HOME" + File.separatorChar + "work" + File.separatorChar + "diagnostic" + " directory."}));
        logger.info(CommandLogger.join(" ", new Object[]{"control.(sh|bat)", CommandList.DIAGNOSTIC, DiagnosticSubCommand.PAGE_LOCKS, PageLocksCommandArg.DUMP_LOG, CommandLogger.optional(PageLocksCommandArg.ALL), CommandLogger.optional(CommandLogger.or(PageLocksCommandArg.NODES, "nodeId1,nodeId2,..")), CommandLogger.optional(CommandLogger.or(PageLocksCommandArg.NODES, "consistentId1,consistentId2,..")), "// Pring page locks dump to console on the node or nodes."}));
        logger.info("");
    }

    @Override
    public String name() {
        return DiagnosticSubCommand.PAGE_LOCKS.toString();
    }

    private void printResult(Map<ClusterNode, VisorPageLocksResult> res) {
        res.forEach((n, res0) -> this.logger.info(n.id() + " (" + n.consistentId() + ") " + res0.result()));
    }

    static enum PageLocksCommandArg implements CommandArg
    {
        DUMP("dump"),
        DUMP_LOG("dump_log"),
        PATH("--path"),
        NODES("--nodes"),
        ALL("--all");

        private final String name;

        private PageLocksCommandArg(String name) {
            this.name = name;
        }

        @Override
        public String argName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Arguments {
        private final Operation op;
        private final String filePath;
        private final boolean allNodes;
        private final Set<String> nodeIds;

        public Arguments(Operation op, String filePath, boolean allNodes, Set<String> nodeIds) {
            this.op = op;
            this.filePath = filePath;
            this.allNodes = allNodes;
            this.nodeIds = nodeIds;
        }
    }
}

