/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.diagnostic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.diagnostic.DiagnosticSubCommand;
import org.apache.ignite.internal.visor.diagnostic.availability.VisorConnectivityArgs;
import org.apache.ignite.internal.visor.diagnostic.availability.VisorConnectivityResult;
import org.apache.ignite.internal.visor.diagnostic.availability.VisorConnectivityTask;

public class ConnectivityCommand
implements Command<Void> {
    private final List<String> TABLE_HEADER = Arrays.asList("SOURCE-NODE-ID", "SOURCE-CONSISTENT-ID", "SOURCE-NODE-TYPE", "DESTINATION-NODE-ID", "DESTINATION_CONSISTENT_ID", "DESTINATION-NODE-TYPE");
    private final String NODE_TYPE_CLIENT = "CLIENT";
    private final String NODE_TYPE_SERVER = "SERVER";
    private IgniteLogger logger;

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger logger) throws Exception {
        Map result;
        this.logger = logger;
        try (GridClient client = Command.startClient(clientCfg);){
            Set nodeIds = client.compute().nodes().stream().map(GridClientNode::nodeId).collect(Collectors.toSet());
            VisorConnectivityArgs taskArg = new VisorConnectivityArgs(nodeIds);
            result = (Map)TaskExecutor.executeTask(client, VisorConnectivityTask.class, taskArg, clientCfg);
        }
        this.printResult(result);
        return result;
    }

    private void printResult(Map<ClusterNode, VisorConnectivityResult> res) {
        boolean[] hasFailed = new boolean[]{false};
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(this.TABLE_HEADER);
        for (Map.Entry<ClusterNode, VisorConnectivityResult> entry : res.entrySet()) {
            ClusterNode key = entry.getKey();
            String id = key.id().toString();
            String consId = key.consistentId().toString();
            String isClient = key.isClient() ? "CLIENT" : "SERVER";
            VisorConnectivityResult value = entry.getValue();
            Map statuses = value.getNodeIds();
            List row = statuses.entrySet().stream().map(nodeStat -> {
                ClusterNode remoteNode = (ClusterNode)nodeStat.getKey();
                String remoteId = remoteNode.id().toString();
                String remoteConsId = remoteNode.consistentId().toString();
                String nodeType = remoteNode.isClient() ? "CLIENT" : "SERVER";
                Boolean status = (Boolean)nodeStat.getValue();
                if (!status.booleanValue()) {
                    hasFailed[0] = true;
                    return Arrays.asList(id, consId, isClient, remoteId, remoteConsId, nodeType);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            table.addAll(row);
        }
        if (hasFailed[0]) {
            this.logger.info("There is no connectivity between the following nodes:\n" + ConnectivityCommand.formatAsTable(table));
        } else {
            this.logger.info("There are no connectivity problems.");
        }
    }

    public static String formatAsTable(List<List<String>> rows) {
        int[] maxLengths = new int[rows.get(0).size()];
        for (List<String> list : rows) {
            for (int i = 0; i < list.size(); ++i) {
                maxLengths[i] = Math.max(maxLengths[i], list.get(i).length());
            }
        }
        StringBuilder formatBuilder = new StringBuilder();
        for (int maxLength : maxLengths) {
            formatBuilder.append("%-").append(maxLength + 2).append("s");
        }
        String string = formatBuilder.toString();
        StringBuilder result = new StringBuilder();
        for (List<String> row : rows) {
            result.append(String.format(string, row.toArray(new String[0]))).append("\n");
        }
        return result.toString();
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public void printUsage(IgniteLogger logger) {
        logger.info("View connectvity state of all nodes in cluster");
        logger.info(CommandLogger.join(" ", new Object[]{"control.(sh|bat)", CommandList.DIAGNOSTIC, DiagnosticSubCommand.CONNECTIVITY, "// Prints info about connectivity between nodes"}));
        logger.info("");
    }

    @Override
    public String name() {
        return DiagnosticSubCommand.CONNECTIVITY.name();
    }
}

