/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.consistency;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.consistency.ConsistencySubCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyRepairTaskArg;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyTaskResult;

public class ConsistencyCommand
extends AbstractCommand<Object> {
    public static final String CACHE = "--cache";
    public static final String PARTITIONS = "--partitions";
    public static final String STRATEGY = "--strategy";
    public static final String PARALLEL = "--parallel";
    private VisorConsistencyRepairTaskArg cmdArg;
    private ConsistencySubCommand cmd;
    private boolean parallel;
    private static final Predicate<GridClientNode> SRV_NODES = node -> !node.isClient();

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        String output;
        try (GridClient client = Command.startClient(clientCfg);){
            if (this.cmd == ConsistencySubCommand.FINALIZE_COUNTERS) {
                output = (String)TaskExecutor.executeTaskByNameOnNode(client, this.cmd.taskName(), this.arg(), null, clientCfg);
            } else {
                StringBuilder sb = new StringBuilder();
                boolean failed = false;
                Set<UUID> nodeIds = this.parallel ? Collections.singleton(TaskExecutor.BROADCAST_UUID) : client.compute().nodes().stream().filter(SRV_NODES).map(GridClientNode::nodeId).collect(Collectors.toSet());
                for (UUID nodeId : nodeIds) {
                    VisorConsistencyTaskResult res = (VisorConsistencyTaskResult)TaskExecutor.executeTaskByNameOnNode(client, this.cmd.taskName(), this.arg(), nodeId, clientCfg);
                    if (res.cancelled()) {
                        sb.append("Operation execution cancelled.\n\n");
                        failed = true;
                    }
                    if (res.failed()) {
                        sb.append("Operation execution failed.\n\n");
                        failed = true;
                    }
                    if (failed) {
                        sb.append("[EXECUTION FAILED OR CANCELLED, RESULTS MAY BE INCOMPLETE OR INCONSISTENT]\n\n");
                    }
                    if (res.message() != null) {
                        sb.append(res.message());
                    } else assert (!this.parallel);
                    if (!failed) continue;
                    break;
                }
                output = sb.toString();
                if (failed) {
                    throw new IgniteCheckedException(output);
                }
            }
        }
        catch (Throwable e) {
            log.error("Failed to perform operation.");
            log.error(CommandLogger.errorMessage(e));
            throw e;
        }
        log.info(output);
        return output;
    }

    @Override
    public VisorConsistencyRepairTaskArg arg() {
        return this.cmdArg;
    }

    @Override
    public void printUsage(IgniteLogger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("cache-name", "Cache to be checked/repaired.");
        params.put("partition", "Cache's partition to be checked/repaired.");
        this.usage(log, "Check/Repair cache consistency using Read Repair approach:", CommandList.CONSISTENCY, params, ConsistencySubCommand.REPAIR.toString(), "cache-name", "partition");
        this.usage(log, "Cache consistency check/repair operations status:", CommandList.CONSISTENCY, Collections.emptyMap(), ConsistencySubCommand.STATUS.toString());
        this.usage(log, "Finalize partitions update counters:", CommandList.CONSISTENCY, Collections.emptyMap(), ConsistencySubCommand.FINALIZE_COUNTERS.toString());
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.cmd = ConsistencySubCommand.of(argIter.nextArg("Expected consistency action."));
        boolean bl = this.parallel = this.cmd != ConsistencySubCommand.REPAIR;
        if (this.cmd == ConsistencySubCommand.REPAIR) {
            String arg;
            String cacheOrGrpName = null;
            Collection parts = null;
            ReadRepairStrategy strategy = null;
            block12: while (argIter.hasNextArg() && (CACHE.equals(arg = argIter.peekNextArg()) || PARTITIONS.equals(arg) || STRATEGY.equals(arg) || PARALLEL.equals(arg))) {
                switch (arg = argIter.nextArg("Expected parameter key.")) {
                    case "--cache": {
                        cacheOrGrpName = argIter.nextArg("Expected cache(group) name.");
                        continue block12;
                    }
                    case "--partitions": {
                        parts = argIter.nextStringSet("Expected comma separated list of partitions.").stream().map(Integer::parseInt).collect(Collectors.toSet());
                        continue block12;
                    }
                    case "--strategy": {
                        strategy = ReadRepairStrategy.fromString((String)argIter.nextArg("Expected strategy."));
                        continue block12;
                    }
                    case "--parallel": {
                        this.parallel = true;
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Illegal argument: " + arg);
            }
            if (cacheOrGrpName == null) {
                throw new IllegalArgumentException("Cache (or cache group) name argument missed.");
            }
            if (F.isEmpty(parts)) {
                throw new IllegalArgumentException("Partitions argument missed.");
            }
            if (strategy == null) {
                throw new IllegalArgumentException("Strategy argument missed.");
            }
            if (this.parallel && strategy != ReadRepairStrategy.CHECK_ONLY) {
                throw new UnsupportedOperationException("Parallel mode currently allowed only when CHECK_ONLY strategy is chosen.");
            }
            this.cmdArg = new VisorConsistencyRepairTaskArg(cacheOrGrpName, parts, strategy);
        } else if (this.cmd == ConsistencySubCommand.STATUS || this.cmd == ConsistencySubCommand.FINALIZE_COUNTERS) {
            this.cmdArg = null;
        } else {
            throw new IllegalArgumentException("Unsupported operation.");
        }
    }

    @Override
    public String name() {
        return CommandList.CONSISTENCY.toCommandName();
    }

    @Override
    public boolean experimental() {
        return true;
    }
}

