/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cdc;

import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.cdc.VisorCdcCacheDataResendTask;
import org.apache.ignite.internal.visor.cdc.VisorCdcCacheDataResendTaskArg;

public class ResendCommand
extends AbstractCommand<Object> {
    public static final String RESEND = "resend";
    public static final String CACHES = "--caches";
    private VisorCdcCacheDataResendTaskArg arg;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            TaskExecutor.executeTaskByNameOnNode(client, VisorCdcCacheDataResendTask.class.getName(), this.arg, null, clientCfg);
            String res = "Successfully resent all cache data to CDC.";
            log.info(res);
            String string = res;
            return string;
        }
        catch (Throwable e) {
            log.error("Failed to perform operation.");
            log.error(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        Set<String> caches = null;
        while (argIter.hasNextSubArg()) {
            String opt = argIter.nextArg("Failed to read command argument.");
            if (!CACHES.equalsIgnoreCase(opt)) continue;
            if (caches != null) {
                throw new IllegalArgumentException("--caches arg specified twice.");
            }
            caches = argIter.nextStringSet("comma-separated list of cache names.");
        }
        if (F.isEmpty(caches)) {
            throw new IllegalArgumentException("At least one cache name should be specified.");
        }
        this.arg = new VisorCdcCacheDataResendTaskArg(caches);
    }

    @Override
    public void printUsage(IgniteLogger logger) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("--caches cache1,...,cacheN", "specifies a comma-separated list of cache names.");
        this.usage(logger, "Forcefully resend all cache data to CDC. Iterates over caches and writes primary copies of data entries to the WAL to get captured by CDC:", CommandList.CDC, params, RESEND, CACHES, "cache1,...,cacheN");
    }

    @Override
    public Object arg() {
        return this.arg;
    }

    @Override
    public String name() {
        return RESEND;
    }

    @Override
    public boolean experimental() {
        return true;
    }
}

