/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cdc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.cdc.VisorCdcDeleteLostSegmentsTask;

public class DeleteLostSegmentLinksCommand
extends AbstractCommand<Object> {
    public static final String DELETE_LOST_SEGMENT_LINKS = "delete_lost_segment_links";
    public static final String NODE_ID = "--node-id";
    private UUID nodeId;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            TaskExecutor.executeTaskByNameOnNode(client, VisorCdcDeleteLostSegmentsTask.class.getName(), null, this.nodeId, clientCfg);
            List<UUID> nodeIds = this.nodeId != null ? Collections.singletonList(this.nodeId) : (Collection)client.compute().nodes(node -> !node.isClient()).stream().map(GridClientNode::nodeId).collect(Collectors.toSet());
            client.compute().execute(VisorCdcDeleteLostSegmentsTask.class.getName(), (Object)new VisorTaskArgument(nodeIds, false));
            String res = "Lost segment CDC links successfully removed.";
            log.info(res);
            String string = res;
            return string;
        }
        catch (Throwable e) {
            log.error("Failed to perform operation.");
            log.error(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.nodeId = null;
        while (argIter.hasNextSubArg()) {
            String opt = argIter.nextArg("Failed to read command argument.");
            if (!NODE_ID.equalsIgnoreCase(opt)) continue;
            this.nodeId = argIter.nextUuidArg(NODE_ID);
        }
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: The command will fix WAL segments gap in case CDC link creation was stopped by distributed property or excess of maximum CDC directory size. Gap will be fixed by deletion of WAL segment linksprevious to the last gap." + U.nl() + "All changes in deleted segment links will be lost!" + U.nl() + "Make sure you need to sync data before restarting the CDC application. You can synchronize caches using snapshot or other methods.";
    }

    @Override
    public void printUsage(IgniteLogger logger) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("--node-id node_id", "ID of the node to delete lost segment links from. If not set, the command will affect all server nodes.");
        this.usage(logger, "Delete lost segment CDC links:", CommandList.CDC, params, DELETE_LOST_SEGMENT_LINKS, CommandLogger.optional(NODE_ID, "node_id"), CommandLogger.optional("--yes"));
    }

    @Override
    public Object arg() {
        return null;
    }

    @Override
    public String name() {
        return DELETE_LOST_SEGMENT_LINKS;
    }

    @Override
    public boolean experimental() {
        return true;
    }
}

