/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.cache.VisorCacheScanTask;
import org.apache.ignite.internal.visor.cache.VisorCacheScanTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheScanTaskResult;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;

public class CacheScan
extends AbstractCommand<Arguments> {
    private static final int DFLT_LIMIT = 1000;
    private Arguments args;

    @Override
    public void printUsage(IgniteLogger log) {
        String description = "Show cache content.";
        Map map = F.asMap((Object)"--limit", (Object)"limit count of entries to scan (1000 by default)");
        this.usageCache(log, CacheSubcommands.SCAN, description, map, "cacheName", CommandLogger.optional("--limit", "N"));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        VisorCacheScanTaskResult res;
        VisorCacheScanTaskArg taskArg = new VisorCacheScanTaskArg(this.args.cacheName, this.args.limit);
        try (GridClient client = Command.startClient(clientCfg);){
            res = (VisorCacheScanTaskResult)TaskExecutor.executeTask(client, VisorCacheScanTask.class, taskArg, clientCfg);
            List<VisorSystemViewTask.SimpleType> types = res.titles().stream().map(x -> VisorSystemViewTask.SimpleType.STRING).collect(Collectors.toList());
            SystemViewCommand.printTable(res.titles(), types, res.entries(), log);
            if (res.entries().size() == this.args.limit) {
                log.info("Result limited to " + this.args.limit + " rows. Limit can be changed with '--limit' argument.");
            }
        }
        return res;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String cacheName = argIter.nextArg("Cache name is expected");
        int limit = 1000;
        while (argIter.hasNextSubArg()) {
            String nextArg = argIter.nextArg("").toLowerCase();
            if ("--limit".equals(nextArg)) {
                limit = argIter.nextIntArg("limit");
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + nextArg);
        }
        this.args = new Arguments(cacheName, limit);
    }

    @Override
    public String name() {
        return CacheSubcommands.SCAN.text().toUpperCase();
    }

    public static class Arguments {
        private final String cacheName;
        private final int limit;

        public Arguments(String cacheName, int limit) {
            this.cacheName = cacheName;
            this.limit = limit;
        }
    }
}

