/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.IndexListCommandArg;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.index.IndexRebuildStatusInfoContainer;
import org.apache.ignite.internal.visor.cache.index.IndexRebuildStatusTask;
import org.apache.ignite.internal.visor.cache.index.IndexRebuildStatusTaskArg;

public class CacheIndexesRebuildStatus
extends AbstractCommand<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(IgniteLogger logger) {
        String desc = "List all indexes that have index rebuild in progress.";
        LinkedHashMap map = U.newLinkedHashMap((int)8);
        map.put(IndexListCommandArg.NODE_ID.argName() + " nodeId", "Specify node for job execution. If not specified explicitly, info will be gathered from all nodes");
        this.usageCache(logger, CacheSubcommands.INDEX_REBUILD_STATUS, desc, map, CommandLogger.optional(IndexListCommandArg.NODE_ID + " nodeId"));
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger logger) throws Exception {
        Map taskRes;
        UUID nodeId = this.args.nodeId;
        IndexRebuildStatusTaskArg taskArg = new IndexRebuildStatusTaskArg(nodeId);
        try (GridClient client = Command.startClient(clientCfg);){
            taskRes = (Map)TaskExecutor.executeTaskByNameOnNode(client, IndexRebuildStatusTask.class.getName(), taskArg, nodeId, clientCfg);
        }
        this.printStatus(taskRes, logger);
        return taskRes;
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public String name() {
        return CacheSubcommands.INDEX_REBUILD_STATUS.text().toUpperCase();
    }

    @Override
    public void parseArguments(CommandArgIterator argIterator) {
        UUID nodeId = null;
        while (argIterator.hasNextSubArg()) {
            String nextArg = argIterator.nextArg("");
            IndexListCommandArg arg = CommandArgUtils.of(nextArg, IndexListCommandArg.class);
            if (arg == IndexListCommandArg.NODE_ID) {
                if (nodeId != null) {
                    throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                }
                nodeId = UUID.fromString(argIterator.nextArg("Failed to read node id"));
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + nextArg);
        }
        this.args = new Arguments(nodeId);
    }

    private void printStatus(Map<UUID, Set<IndexRebuildStatusInfoContainer>> res, IgniteLogger logger) {
        if (res.isEmpty()) {
            logger.info("There are no caches that have index rebuilding in progress.");
            logger.info("");
            return;
        }
        logger.info("Caches that have index rebuilding in progress:");
        for (Map.Entry<UUID, Set<IndexRebuildStatusInfoContainer>> entry : res.entrySet()) {
            logger.info("");
            entry.getValue().stream().sorted(IndexRebuildStatusInfoContainer.comparator()).forEach(container -> logger.info(this.constructCacheOutputString((UUID)entry.getKey(), (IndexRebuildStatusInfoContainer)container)));
        }
        logger.info("");
    }

    private String constructCacheOutputString(UUID nodeId, IndexRebuildStatusInfoContainer container) {
        return "node_id=" + nodeId + ", " + container.toString();
    }

    public static class Arguments {
        private UUID nodeId;

        public Arguments(UUID nodeId) {
            this.nodeId = nodeId;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }
    }
}

