/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.DistributionCommandArg;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTask;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskArg;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskResult;

public class CacheDistribution
extends AbstractCommand<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(IgniteLogger logger) {
        String CACHES = "cacheName1,...,cacheNameN";
        String description = "Prints the information about partition distribution.";
        this.usageCache(logger, CacheSubcommands.DISTRIBUTION, description, null, CommandLogger.or("nodeId", "null"), CommandLogger.optional(CACHES), CommandLogger.optional(DistributionCommandArg.USER_ATTRIBUTES, "attrName1,...,attrNameN"));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger logger) throws Exception {
        CacheDistributionTaskResult res;
        CacheDistributionTaskArg taskArg = new CacheDistributionTaskArg(this.args.caches(), this.args.getUserAttributes());
        UUID nodeId = this.args.nodeId() == null ? TaskExecutor.BROADCAST_UUID : this.args.nodeId();
        try (GridClient client = Command.startClient(clientCfg);){
            res = (CacheDistributionTaskResult)TaskExecutor.executeTaskByNameOnNode(client, CacheDistributionTask.class.getName(), taskArg, nodeId, clientCfg);
        }
        CommandLogger.printErrors(res.exceptions(), "Cache distrubution task failed on nodes:", logger);
        res.print(System.out);
        return res;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        UUID nodeId = null;
        Set<String> caches = null;
        HashSet<String> userAttributes = null;
        String nodeIdStr = argIter.nextArg("Node id expected or null");
        if (!"null".equals(nodeIdStr)) {
            nodeId = UUID.fromString(nodeIdStr);
        }
        while (argIter.hasNextSubArg()) {
            String nextArg = argIter.nextArg("");
            DistributionCommandArg arg = CommandArgUtils.of(nextArg, DistributionCommandArg.class);
            if (arg == DistributionCommandArg.USER_ATTRIBUTES) {
                nextArg = argIter.nextArg("User attributes are expected to be separated by commas");
                userAttributes = new HashSet<String>();
                for (String userAttribute : nextArg.split(",")) {
                    userAttributes.add(userAttribute.trim());
                }
                String string = nextArg = argIter.hasNextSubArg() ? argIter.nextArg("") : null;
            }
            if (nextArg == null) continue;
            caches = argIter.parseStringSet(nextArg);
        }
        this.args = new Arguments(caches, nodeId, userAttributes);
    }

    @Override
    public String name() {
        return CacheSubcommands.DISTRIBUTION.text().toUpperCase();
    }

    public class Arguments {
        private Set<String> caches;
        private UUID nodeId;
        private Set<String> userAttributes;

        public Arguments(Set<String> caches, UUID nodeId, Set<String> userAttributes) {
            this.caches = caches;
            this.nodeId = nodeId;
            this.userAttributes = userAttributes;
        }

        public Set<String> caches() {
            return this.caches;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public Set<String> getUserAttributes() {
            return this.userAttributes;
        }
    }
}

