/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.cache.VisorCacheStopTask;
import org.apache.ignite.internal.visor.cache.VisorCacheStopTaskArg;

public class CacheDestroy
extends AbstractCommand<VisorCacheStopTaskArg> {
    public static final String DESTROY_ALL_ARG = "--destroy-all-caches";
    public static final String CACHE_NAMES_ARG = "--caches";
    public static final String CONFIRM_MSG = "Warning! The command will destroy %d caches: %s.\nIf you continue, the cache data will be impossible to recover.";
    public static final String NOOP_MSG = "No user-created caches exist.";
    public static final String RESULT_MSG = "The following caches have been stopped: %s.";
    private boolean destroyAll;
    private Set<String> cacheNames;

    @Override
    public VisorCacheStopTaskArg arg() {
        return new VisorCacheStopTaskArg(new ArrayList<String>(this.cacheNames));
    }

    @Override
    public void printUsage(IgniteLogger log) {
        String cacheNamesArgFull = "--caches cache1,...,cacheN";
        this.usageCache(log, CacheSubcommands.DESTROY, "Permanently destroy specified caches.", F.asMap((Object)cacheNamesArgFull, (Object)"specifies a comma-separated list of cache names to be destroyed.", (Object)DESTROY_ALL_ARG, (Object)"permanently destroy all user-created caches."), CommandLogger.or(cacheNamesArgFull, DESTROY_ALL_ARG));
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.cacheNames = null;
        this.destroyAll = false;
        String requiredArgsMsg = "One of \"--caches\" or \"--destroy-all-caches\" is expected.";
        String cmdArg = argIter.nextArg(requiredArgsMsg);
        if (DESTROY_ALL_ARG.equals(cmdArg)) {
            this.destroyAll = true;
        } else if (CACHE_NAMES_ARG.equals(cmdArg)) {
            this.cacheNames = new TreeSet<String>(argIter.nextStringSet("cache names"));
        } else {
            throw new IllegalArgumentException("Invalid argument \"" + cmdArg + "\". " + requiredArgsMsg);
        }
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Invalid argument \"" + argIter.peekNextArg() + "\", no more arguments is expected.");
        }
    }

    @Override
    public void prepareConfirmation(GridClientConfiguration clientCfg) throws Exception {
        if (this.destroyAll) {
            this.cacheNames = this.collectClusterCaches(clientCfg);
        }
    }

    @Override
    public String confirmationPrompt() {
        if (F.isEmpty(this.cacheNames)) {
            return null;
        }
        return String.format(CONFIRM_MSG, this.cacheNames.size(), S.joinToString(this.cacheNames, (String)", ", (String)"..", (int)80, (int)0));
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        if (this.destroyAll && this.cacheNames == null) {
            this.cacheNames = this.collectClusterCaches(clientCfg);
        }
        if (this.cacheNames.isEmpty()) {
            assert (this.destroyAll);
            log.info(NOOP_MSG);
            return null;
        }
        try (GridClient client = Command.startClient(clientCfg);){
            TaskExecutor.executeTask(client, VisorCacheStopTask.class, this.arg(), clientCfg);
        }
        log.info(String.format(RESULT_MSG, F.concat(this.cacheNames, (String)", ")));
        return null;
    }

    @Override
    public String name() {
        return CacheSubcommands.DESTROY.text().toUpperCase();
    }

    private Set<String> collectClusterCaches(GridClientConfiguration clientCfg) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            TreeSet caches = new TreeSet();
            for (GridClientNode node : client.compute().nodes(GridClientNode::connectable)) {
                caches.addAll(node.caches().keySet());
            }
            TreeSet treeSet = caches;
            return treeSet;
        }
    }
}

