/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.processors.cache.ClearCachesTask;
import org.apache.ignite.internal.processors.cache.ClearCachesTaskArg;
import org.apache.ignite.internal.processors.cache.ClearCachesTaskResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheClear
extends AbstractCommand<ClearCachesTaskArg> {
    public static final String CLEAR_MSG = "The following caches have been cleared: %s";
    public static final String SKIP_CLEAR_MSG = "The following caches don't exist: %s";
    public static final String CONFIRM_MSG = "Warning! The command will clear all data from %d caches: %s.\nIf you continue, it will be impossible to recover cleared data.";
    public static final String CACHES = "--caches";
    private ClearCachesTaskArg arg;

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            ClearCachesTaskResult res = (ClearCachesTaskResult)TaskExecutor.executeTask(client, ClearCachesTask.class, this.arg(), clientCfg);
            if (!F.isEmpty((Collection)res.clearedCaches())) {
                U.log((IgniteLogger)log, (Object)String.format(CLEAR_MSG, String.join((CharSequence)", ", res.clearedCaches())));
            }
            if (!F.isEmpty((Collection)res.nonExistentCaches())) {
                U.warn((IgniteLogger)log, (Object)String.format(SKIP_CLEAR_MSG, String.join((CharSequence)", ", res.nonExistentCaches())));
            }
        }
        return null;
    }

    @Override
    public String confirmationPrompt() {
        return String.format(CONFIRM_MSG, this.arg.caches().size(), String.join((CharSequence)", ", this.arg.caches()));
    }

    @Override
    public ClearCachesTaskArg arg() {
        return this.arg;
    }

    @Override
    public void printUsage(IgniteLogger logger) {
        this.usageCache(logger, CacheSubcommands.CLEAR, "Clear specified caches.", F.asMap((Object)CACHES, (Object)"specifies a comma-separated list of cache names to be cleared."), new String[0]);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String cmdArg = argIter.nextArg("Command arguments are expected.");
        if (cmdArg == null) {
            throw new IllegalArgumentException("Unknown argument: " + cmdArg);
        }
        if (!CACHES.equals(cmdArg)) {
            throw new IllegalArgumentException("Unknown argument: " + cmdArg);
        }
        String cacheNamesArg = argIter.nextArg("Expected a comma-separated cache names.");
        List caches = Arrays.stream(cacheNamesArg.split(",")).collect(Collectors.toList());
        this.arg = new ClearCachesTaskArg(caches);
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Invalid argument \"" + argIter.peekNextArg() + "\", no more arguments are expected.");
        }
    }

    @Override
    public String name() {
        return CacheSubcommands.CLEAR.text().toUpperCase();
    }
}

