/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.baseline;

import java.util.List;
import org.apache.ignite.internal.commandline.baseline.BaselineSubcommands;

public class BaselineArguments {
    private BaselineSubcommands cmd;
    private Boolean enableAutoAdjust;
    private Long softBaselineTimeout;
    private long topVer = -1L;
    List<String> consistentIds;

    public BaselineArguments(BaselineSubcommands cmd, Boolean enableAutoAdjust, Long softBaselineTimeout, long topVer, List<String> consistentIds) {
        this.cmd = cmd;
        this.enableAutoAdjust = enableAutoAdjust;
        this.softBaselineTimeout = softBaselineTimeout;
        this.topVer = topVer;
        this.consistentIds = consistentIds;
    }

    public BaselineSubcommands getCmd() {
        return this.cmd;
    }

    public Boolean getEnableAutoAdjust() {
        return this.enableAutoAdjust;
    }

    public Long getSoftBaselineTimeout() {
        return this.softBaselineTimeout;
    }

    public long getTopVer() {
        return this.topVer;
    }

    public List<String> getConsistentIds() {
        return this.consistentIds;
    }

    public static class Builder {
        private BaselineSubcommands cmd;
        private Boolean enable;
        private Long timeout;
        private long ver = -1L;
        private List<String> ids;

        public Builder(BaselineSubcommands cmd) {
            this.cmd = cmd;
        }

        public Builder withEnable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public Builder withSoftBaselineTimeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withTopVer(long ver) {
            this.ver = ver;
            return this;
        }

        public Builder withConsistentIds(List<String> ids) {
            this.ids = ids;
            return this;
        }

        public BaselineArguments build() {
            return new BaselineArguments(this.cmd, this.enable, this.timeout, this.ver, this.ids);
        }
    }
}

