/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Objects;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClientBeforeNodeStart;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.argument.CommandArg;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;

public class WarmUpCommand
extends AbstractCommand<Void> {
    @Override
    public void printUsage(IgniteLogger logger) {
        this.usage(logger, "Stop warm-up:", CommandList.WARM_UP, WarmUpCommandArg.STOP.argName());
    }

    @Override
    public String name() {
        return CommandList.WARM_UP.toCommandName();
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        WarmUpCommandArg arg;
        String nextArg;
        boolean stop = false;
        block3: while ((nextArg = argIter.peekNextArg()) != null && !Objects.isNull(arg = CommandArgUtils.of(nextArg, WarmUpCommandArg.class))) {
            switch (arg) {
                case STOP: {
                    argIter.nextArg("");
                    stop = true;
                    continue block3;
                }
            }
            throw new AssertionError();
        }
        if (!stop) {
            throw new IllegalArgumentException(WarmUpCommandArg.STOP.argName() + " argument is missing.");
        }
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: command will stop warm-up.";
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger log) throws Exception {
        try (GridClientBeforeNodeStart client = Command.startClientBeforeNodeStart(clientCfg);){
            client.beforeStartState().stopWarmUp();
        }
        catch (GridClientDisconnectedException e) {
            throw new GridClientException(e.getCause());
        }
        return true;
    }

    private static enum WarmUpCommandArg implements CommandArg
    {
        STOP("--stop");

        private final String name;

        private WarmUpCommandArg(String name) {
            this.name = name;
        }

        @Override
        public String argName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

