/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.TxCommandArg;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.tx.FetchNearXidVersionTask;
import org.apache.ignite.internal.visor.tx.TxKeyLockType;
import org.apache.ignite.internal.visor.tx.TxMappingType;
import org.apache.ignite.internal.visor.tx.TxVerboseId;
import org.apache.ignite.internal.visor.tx.TxVerboseInfo;
import org.apache.ignite.internal.visor.tx.TxVerboseKey;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxSortOrder;
import org.apache.ignite.internal.visor.tx.VisorTxTask;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.transactions.TransactionState;

public class TxCommands
extends AbstractCommand<VisorTxTaskArg> {
    private VisorTxTaskArg args;
    private IgniteLogger logger;

    @Override
    public void printUsage(IgniteLogger logger) {
        this.usage(logger, "List or kill transactions:", CommandList.TX, this.getTxOptions());
        this.usage(logger, "Print detailed information (topology and key lock ownership) about specific transaction:", CommandList.TX, TxCommandArg.TX_INFO.argName(), CommandLogger.or("<TX identifier as GridCacheVersion [topVer=..., order=..., nodeOrder=...] (can be found in logs)>", "<TX identifier as UUID (can be retrieved via --tx command)>"));
    }

    private String[] getTxOptions() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(CommandLogger.optional(TxCommandArg.TX_XID, "XID"));
        list.add(CommandLogger.optional(TxCommandArg.TX_DURATION, "SECONDS"));
        list.add(CommandLogger.optional(TxCommandArg.TX_SIZE, "SIZE"));
        list.add(CommandLogger.optional(TxCommandArg.TX_LABEL, "PATTERN_REGEX"));
        list.add(CommandLogger.optional(CommandLogger.or(TxCommandArg.TX_SERVERS, TxCommandArg.TX_CLIENTS)));
        list.add(CommandLogger.optional(TxCommandArg.TX_NODES, "consistentId1[,consistentId2,....,consistentIdN]"));
        list.add(CommandLogger.optional(TxCommandArg.TX_LIMIT, "NUMBER"));
        list.add(CommandLogger.optional(TxCommandArg.TX_ORDER, CommandLogger.or(VisorTxSortOrder.values())));
        list.add(CommandLogger.optional(TxCommandArg.TX_KILL));
        list.add(CommandLogger.optional(TxCommandArg.TX_INFO));
        list.add(CommandLogger.optional("--yes"));
        return list.toArray(new String[list.size()]);
    }

    @Override
    public VisorTxTaskArg arg() {
        return this.args;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, IgniteLogger logger) throws Exception {
        this.logger = logger;
        try (GridClient client = Command.startClient(clientCfg);){
            if (this.args.getOperation() == VisorTxOperation.INFO) {
                Object object = this.transactionInfo(client, clientCfg);
                return object;
            }
            Map res = (Map)TaskExecutor.executeTask(client, VisorTxTask.class, this.args, clientCfg);
            if (res.isEmpty()) {
                logger.info("Nothing found.");
            } else if (this.args.getOperation() == VisorTxOperation.KILL) {
                logger.info("Killed transactions:");
            } else {
                logger.info("Matching transactions:");
            }
            for (Map.Entry entry : res.entrySet()) {
                if (((VisorTxTaskResult)entry.getValue()).getInfos().isEmpty()) continue;
                ClusterNode key = (ClusterNode)entry.getKey();
                logger.info(key.getClass().getSimpleName() + " [id=" + key.id() + ", addrs=" + key.addresses() + ", order=" + key.order() + ", ver=" + key.version() + ", isClient=" + key.isClient() + ", consistentId=" + key.consistentId() + "]");
                for (VisorTxInfo info : ((VisorTxTaskResult)entry.getValue()).getInfos()) {
                    logger.info(info.toUserString());
                }
            }
            Map map = res;
            return map;
        }
        catch (Throwable e) {
            logger.error("Failed to perform operation.");
            logger.error(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    private void transactions(GridClient client, GridClientConfiguration conf) throws GridClientException {
        try {
            if (this.args.getOperation() == VisorTxOperation.INFO) {
                this.transactionInfo(client, conf);
                return;
            }
            Map res = (Map)TaskExecutor.executeTask(client, VisorTxTask.class, this.args, conf);
            for (Map.Entry entry : res.entrySet()) {
                if (((VisorTxTaskResult)entry.getValue()).getInfos().isEmpty()) continue;
                ClusterNode key = (ClusterNode)entry.getKey();
                this.logger.info(TxCommands.nodeDescription(key));
                for (VisorTxInfo info : ((VisorTxTaskResult)entry.getValue()).getInfos()) {
                    this.logger.info(info.toUserString());
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Failed to perform operation.");
            throw e;
        }
    }

    @Override
    public String confirmationPrompt() {
        if (this.args != null && this.args.getOperation() == VisorTxOperation.KILL) {
            return "Warning: the command will kill some transactions.";
        }
        return null;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        TxCommandArg arg;
        String str;
        VisorTxProjection proj = null;
        Integer limit = null;
        VisorTxSortOrder sortOrder = null;
        Long duration = null;
        Integer size = null;
        String lbRegex = null;
        ArrayList<String> consistentIds = null;
        VisorTxOperation op = VisorTxOperation.LIST;
        String xid = null;
        TxVerboseId txVerboseId = null;
        block15: while ((str = argIter.peekNextArg()) != null && (arg = CommandArgUtils.of(str, TxCommandArg.class)) != null) {
            switch (arg) {
                case TX_LIMIT: {
                    argIter.nextArg("");
                    limit = (int)argIter.nextNonNegativeLongArg(TxCommandArg.TX_LIMIT.toString());
                    continue block15;
                }
                case TX_ORDER: {
                    argIter.nextArg("");
                    sortOrder = VisorTxSortOrder.valueOf((String)argIter.nextArg(TxCommandArg.TX_ORDER.toString()).toUpperCase());
                    continue block15;
                }
                case TX_SERVERS: {
                    argIter.nextArg("");
                    proj = VisorTxProjection.SERVER;
                    continue block15;
                }
                case TX_CLIENTS: {
                    argIter.nextArg("");
                    proj = VisorTxProjection.CLIENT;
                    continue block15;
                }
                case TX_NODES: {
                    argIter.nextArg("");
                    Set<String> ids = argIter.nextStringSet(TxCommandArg.TX_NODES.toString());
                    if (ids.isEmpty()) {
                        throw new IllegalArgumentException("Consistent id list is empty.");
                    }
                    consistentIds = new ArrayList<String>(ids);
                    continue block15;
                }
                case TX_DURATION: {
                    argIter.nextArg("");
                    duration = argIter.nextNonNegativeLongArg(TxCommandArg.TX_DURATION.toString()) * 1000L;
                    continue block15;
                }
                case TX_SIZE: {
                    argIter.nextArg("");
                    size = (int)argIter.nextNonNegativeLongArg(TxCommandArg.TX_SIZE.toString());
                    continue block15;
                }
                case TX_LABEL: {
                    argIter.nextArg("");
                    lbRegex = argIter.nextArg(TxCommandArg.TX_LABEL.toString());
                    try {
                        Pattern.compile(lbRegex);
                        continue block15;
                    }
                    catch (PatternSyntaxException ignored) {
                        throw new IllegalArgumentException("Illegal regex syntax");
                    }
                }
                case TX_XID: {
                    argIter.nextArg("");
                    xid = argIter.nextArg(TxCommandArg.TX_XID.toString());
                    continue block15;
                }
                case TX_KILL: {
                    argIter.nextArg("");
                    op = VisorTxOperation.KILL;
                    continue block15;
                }
                case TX_INFO: {
                    argIter.nextArg("");
                    op = VisorTxOperation.INFO;
                    txVerboseId = TxVerboseId.fromString((String)argIter.nextArg(TxCommandArg.TX_INFO.argName()));
                    continue block15;
                }
            }
            throw new AssertionError();
        }
        if (proj != null && consistentIds != null) {
            throw new IllegalArgumentException("Projection can't be used together with list of consistent ids.");
        }
        this.args = new VisorTxTaskArg(op, limit, duration, size, null, proj, consistentIds, xid, lbRegex, sortOrder, txVerboseId);
    }

    private static String nodeDescription(ClusterNode node) {
        return node.getClass().getSimpleName() + " [id=" + node.id() + ", addrs=" + node.addresses() + ", order=" + node.order() + ", ver=" + node.version() + ", isClient=" + node.isClient() + ", consistentId=" + node.consistentId() + "]";
    }

    private Object transactionInfo(GridClient client, GridClientConfiguration conf) throws GridClientException {
        GridClientUtils.checkFeatureSupportedByCluster((GridClient)client, (IgniteFeatures)IgniteFeatures.TX_INFO_COMMAND, (boolean)true, (boolean)true);
        GridCacheVersion nearXidVer = (GridCacheVersion)TaskExecutor.executeTask(client, FetchNearXidVersionTask.class, this.args.txInfoArgument(), conf);
        boolean histMode = false;
        if (nearXidVer != null) {
            this.logger.info("Resolved transaction near XID version: " + nearXidVer);
            this.args.txInfoArgument(new TxVerboseId(null, nearXidVer));
        } else {
            this.logger.info("Active transactions not found.");
            if (this.args.txInfoArgument().gridCacheVersion() != null) {
                this.logger.info("Will try to peek history to find out whether transaction was committed / rolled back.");
                histMode = true;
            } else {
                this.logger.info("You can specify transaction in GridCacheVersion format in order to peek history to find out whether transaction was committed / rolled back.");
                return null;
            }
        }
        Map res = (Map)TaskExecutor.executeTask(client, VisorTxTask.class, this.args, conf);
        if (histMode) {
            this.printTxInfoHistoricalResult(res);
        } else {
            this.printTxInfoResult(res);
        }
        return res;
    }

    private void printTxInfoResult(Map<ClusterNode, VisorTxTaskResult> res) {
        String lb = null;
        HashMap<Integer, String> usedCaches = new HashMap<Integer, String>();
        HashMap<Integer, String> usedCacheGroups = new HashMap<Integer, String>();
        VisorTxInfo firstInfo = null;
        TxVerboseInfo firstVerboseInfo = null;
        HashSet<TransactionState> states = new HashSet<TransactionState>();
        for (Map.Entry<ClusterNode, VisorTxTaskResult> entry : res.entrySet()) {
            for (VisorTxInfo info : entry.getValue().getInfos()) {
                assert (info.getTxVerboseInfo() != null);
                if (lb == null) {
                    lb = info.getLabel();
                }
                if (firstInfo == null) {
                    firstInfo = info;
                    firstVerboseInfo = info.getTxVerboseInfo();
                }
                usedCaches.putAll(info.getTxVerboseInfo().usedCaches());
                usedCacheGroups.putAll(info.getTxVerboseInfo().usedCacheGroups());
                states.add(info.getState());
            }
        }
        String indent = "";
        this.logger.info("");
        this.logger.info(indent + "Transaction detailed info:");
        this.printTransactionDetailedInfo(res, usedCaches, usedCacheGroups, firstInfo, firstVerboseInfo, states, indent + "    ");
    }

    private void printTransactionDetailedInfo(Map<ClusterNode, VisorTxTaskResult> res, Map<Integer, String> usedCaches, Map<Integer, String> usedCacheGroups, VisorTxInfo firstInfo, TxVerboseInfo firstVerboseInfo, Set<TransactionState> states, String indent) {
        this.logger.info(indent + "Near XID version: " + firstVerboseInfo.nearXidVersion());
        this.logger.info(indent + "Near XID version (UUID): " + firstInfo.getNearXid());
        this.logger.info(indent + "Isolation: " + firstInfo.getIsolation());
        this.logger.info(indent + "Concurrency: " + firstInfo.getConcurrency());
        this.logger.info(indent + "Timeout: " + firstInfo.getTimeout());
        this.logger.info(indent + "Initiator node: " + firstVerboseInfo.nearNodeId());
        this.logger.info(indent + "Initiator node (consistent ID): " + firstVerboseInfo.nearNodeConsistentId());
        this.logger.info(indent + "Label: " + firstInfo.getLabel());
        this.logger.info(indent + "Topology version: " + firstInfo.getTopologyVersion());
        this.logger.info(indent + "Used caches (ID to name): " + usedCaches);
        this.logger.info(indent + "Used cache groups (ID to name): " + usedCacheGroups);
        this.logger.info(indent + "States across the cluster: " + states);
        this.logger.info(indent + "Transaction topology: ");
        this.printTransactionTopology(res, indent + "    ");
    }

    private void printTransactionTopology(Map<ClusterNode, VisorTxTaskResult> res, String indent) {
        for (Map.Entry<ClusterNode, VisorTxTaskResult> entry : res.entrySet()) {
            this.logger.info(indent + TxCommands.nodeDescription(entry.getKey()) + ':');
            this.printTransactionMappings(indent + "    ", entry);
        }
    }

    private void printTransactionMappings(String indent, Map.Entry<ClusterNode, VisorTxTaskResult> entry) {
        for (VisorTxInfo info : entry.getValue().getInfos()) {
            TxVerboseInfo verboseInfo = info.getTxVerboseInfo();
            if (verboseInfo != null) {
                this.logger.info(indent + "Mapping [type=" + verboseInfo.txMappingType() + "]:");
                this.printTransactionMapping(indent + "    ", info, verboseInfo);
                continue;
            }
            this.logger.info(indent + "Mapping [type=HISTORICAL]:");
            this.logger.info(indent + "    " + "State: " + info.getState());
        }
    }

    private void printTransactionMapping(String indent, VisorTxInfo info, TxVerboseInfo verboseInfo) {
        this.logger.info(indent + "XID version (UUID): " + info.getXid());
        this.logger.info(indent + "State: " + info.getState());
        if (verboseInfo.txMappingType() == TxMappingType.REMOTE) {
            this.logger.info(indent + "Primary node: " + verboseInfo.dhtNodeId());
            this.logger.info(indent + "Primary node (consistent ID): " + verboseInfo.dhtNodeConsistentId());
        }
        if (!F.isEmpty((Collection)verboseInfo.localTxKeys())) {
            this.logger.info(indent + "Mapped keys:");
            this.printTransactionKeys(indent + "    ", verboseInfo);
        }
    }

    private void printTransactionKeys(String indent, TxVerboseInfo verboseInfo) {
        for (TxVerboseKey txVerboseKey : verboseInfo.localTxKeys()) {
            this.logger.info(indent + (txVerboseKey.read() ? "Read" : "Write") + " [lock=" + txVerboseKey.lockType() + "]: " + txVerboseKey.txKey());
            if (txVerboseKey.lockType() != TxKeyLockType.AWAITS_LOCK) continue;
            this.logger.info(indent + "    " + "Lock owner XID: " + txVerboseKey.ownerVersion());
        }
    }

    private void printTxInfoHistoricalResult(Map<ClusterNode, VisorTxTaskResult> res) {
        if (F.isEmpty(res)) {
            this.logger.info("Transaction was not found in history across the cluster.");
        } else {
            this.logger.info("Transaction was found in completed versions history of the following nodes:");
            for (Map.Entry<ClusterNode, VisorTxTaskResult> entry : res.entrySet()) {
                this.logger.info("    " + TxCommands.nodeDescription(entry.getKey()) + ':');
                this.logger.info("        State: " + ((VisorTxInfo)entry.getValue().getInfos().get(0)).getState());
            }
        }
    }

    @Override
    public String name() {
        return CommandList.TX.toCommandName();
    }
}

