/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.NotNull;

public class CommandArgIterator {
    private final Iterator<String> argsIt;
    private final Map<String, Command<?>> cmds;
    private String peekedArg;
    private final Set<String> commonArgumentsAndHighLevelCommandSet;

    public CommandArgIterator(Iterator<String> argsIt, Set<String> commonArgumentsAndHighLevelCommandSet, Map<String, Command<?>> cmds) {
        this.argsIt = argsIt;
        this.commonArgumentsAndHighLevelCommandSet = commonArgumentsAndHighLevelCommandSet;
        this.cmds = cmds;
    }

    public boolean hasNextArg() {
        return this.peekedArg != null || this.argsIt.hasNext();
    }

    public boolean hasNextSubArg() {
        return this.hasNextArg() && !this.cmds.containsKey(this.peekNextArg().toLowerCase()) && !this.commonArgumentsAndHighLevelCommandSet.contains(this.peekNextArg());
    }

    public String nextArg(String err) {
        if (this.peekedArg != null) {
            String res = this.peekedArg;
            this.peekedArg = null;
            return res;
        }
        if (this.argsIt.hasNext()) {
            return this.argsIt.next();
        }
        throw new IllegalArgumentException(err);
    }

    public String peekNextArg() {
        if (this.peekedArg == null && this.argsIt.hasNext()) {
            this.peekedArg = this.argsIt.next();
        }
        return this.peekedArg;
    }

    public long nextNonNegativeLongArg(String argName) {
        long val = this.nextLongArg(argName);
        if (val < 0L) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + val);
        }
        return val;
    }

    public int nextNonNegativeIntArg(String argName) {
        int val = this.nextIntArg(argName);
        if (val < 0) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + val);
        }
        return val;
    }

    public long nextLongArg(String argName) {
        String str = this.nextArg("Expecting " + argName);
        try {
            return str.startsWith("0x") ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + str);
        }
    }

    public int nextIntArg(String argName) {
        String str = this.nextArg("Expecting " + argName);
        try {
            return str.startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid value for " + argName + ": " + str);
        }
    }

    public UUID nextUuidArg(String argName) {
        String str = this.nextArg("Expecting " + argName + " command argument.");
        try {
            return UUID.fromString(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to parse " + argName + " command argument. String representation of \"java.util.UUID\" is exepected. For example: 123e4567-e89b-42d3-a456-556642440000", e);
        }
    }

    public Set<String> nextStringSet(String argName) {
        String nextArg = this.peekNextArg();
        if (CommandArgIterator.isCommandOrOption(nextArg)) {
            return Collections.emptySet();
        }
        nextArg = this.nextArg("Expected " + argName);
        return this.parseStringSet(nextArg);
    }

    @NotNull
    public Set<String> parseStringSet(String string) {
        HashSet<String> namesSet = new HashSet<String>();
        for (String name : string.split(",")) {
            if (F.isEmpty((String)name)) {
                throw new IllegalArgumentException("Non-empty string expected.");
            }
            namesSet.add(name.trim());
        }
        return namesSet;
    }

    public static boolean isCommandOrOption(String raw) {
        return raw != null && raw.contains("--");
    }
}

