/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.startup.cmdline;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import javax.swing.ImageIcon;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.IgnitionListener;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.binary.BinaryArray;
import org.apache.ignite.internal.processors.cache.ExchangeContext;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.PartitionsEvictManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEventBuffer;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.util.GridConfigurationFinder;
import org.apache.ignite.internal.util.OffheapReadWriteLock;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConfiguration;
import org.apache.ignite.spi.deployment.local.LocalDeploymentSpi;
import org.apache.ignite.startup.cmdline.AboutDialog;
import org.jetbrains.annotations.Nullable;

public final class CommandLineStartup {
    private static final boolean QUITE;
    static final String PRINT_PROPS_COMMAND = "-systemProps";
    static final List<Class<?>> PROPS_CLS;
    public static final String DFLT_PROG_NAME = "ignite.{sh|bat}";

    private CommandLineStartup() {
    }

    private static void exit(@Nullable String errMsg, boolean showUsage, int exitCode) {
        int space;
        String runner;
        if (errMsg != null) {
            X.error(errMsg, new Object[0]);
        }
        runner = runner.substring(0, (space = (runner = System.getProperty("IGNITE_PROG_NAME", DFLT_PROG_NAME)).indexOf(32)) == -1 ? runner.length() : space);
        if (showUsage) {
            boolean ignite = runner.contains("ignite.");
            X.error("Usage:", "    " + runner + (ignite ? " [?]|[path {-v}{-np}]|[-i]" : " [?]|[-v]"), "    Where:", "    ?, /help, -help, - show this message.", "    -v               - verbose mode (quiet by default).", "    -np              - no pause on exit (pause by default)", "    -systemProps     - prints Ignite system properties info.");
            if (ignite) {
                X.error("    -i              - interactive mode (choose configuration file from list).", "    path            - path to Spring XML configuration file.", "                      Path can be absolute or relative to IGNITE_HOME.", " ", "Spring file should contain one bean definition of Java type", "'org.apache.ignite.configuration.IgniteConfiguration'. Note that bean will be", "fetched by the type and its ID is not used.");
            }
        }
        System.exit(exitCode);
    }

    public static boolean isHelp(String arg) {
        String s = arg.startsWith("--") ? arg.substring(2) : (arg.startsWith("-") || arg.startsWith("/") || arg.startsWith("\\") ? arg.substring(1) : arg);
        return "?".equals(s) || "help".equalsIgnoreCase(s) || "h".equalsIgnoreCase(s);
    }

    @Nullable
    private static String askConfigFile() throws IOException {
        List<GridTuple3<String, Long, File>> files = GridConfigurationFinder.getConfigFiles();
        String title = "Available configuration files:";
        X.println(title, new Object[0]);
        X.println(U.dash(title.length()), new Object[0]);
        for (int i = 0; i < files.size(); ++i) {
            System.out.println(i + ":\t" + files.get(i).get1());
        }
        X.print("\nChoose configuration file ('c' to cancel) [0]: ", new Object[0]);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = reader.readLine();
        if ("c".equalsIgnoreCase(line)) {
            System.out.println("\nOperation cancelled.");
            return null;
        }
        if (line != null && line.isEmpty()) {
            line = "0";
        }
        try {
            GridTuple3<String, Long, File> file = files.get(Integer.valueOf(line));
            X.println("\nUsing configuration: " + file.get1() + "\n", new Object[0]);
            return file.get3().getAbsolutePath();
        }
        catch (Exception ignored) {
            X.error("\nInvalid selection: " + line, new Object[0]);
            return null;
        }
    }

    public static void main(String[] args) {
        String igniteInstanceName;
        if (!QUITE) {
            X.println("Ignite Command Line Startup, ver. " + IgniteVersionUtils.ACK_VER_STR, new Object[0]);
            X.println(IgniteVersionUtils.COPYRIGHT, new Object[0]);
            X.println();
        }
        if (args.length > 1) {
            CommandLineStartup.exit("Too many arguments.", true, -1);
        }
        if (args.length > 0 && CommandLineStartup.isHelp(args[0])) {
            CommandLineStartup.exit(null, true, 0);
        }
        if (args.length > 0 && PRINT_PROPS_COMMAND.equalsIgnoreCase(args[0])) {
            CommandLineStartup.printSystemPropertiesInfo();
            CommandLineStartup.exit(null, false, 0);
        }
        if (args.length > 0 && args[0].isEmpty()) {
            CommandLineStartup.exit("Empty argument.", true, 1);
        }
        if (args.length > 0 && args[0].charAt(0) == '-') {
            CommandLineStartup.exit("Invalid arguments: " + args[0], true, -1);
        }
        String cfg = null;
        if (args.length > 0) {
            cfg = args[0];
        } else {
            try {
                cfg = CommandLineStartup.askConfigFile();
                if (cfg == null) {
                    CommandLineStartup.exit(null, false, 0);
                }
            }
            catch (IOException e) {
                CommandLineStartup.exit("Failed to run interactive mode: " + e.getMessage(), false, -1);
            }
        }
        try {
            igniteInstanceName = G.start(cfg).name();
        }
        catch (Throwable e) {
            e.printStackTrace();
            String note = "";
            if (X.hasCause(e, ClassNotFoundException.class)) {
                note = "\nNote! You may use 'USER_LIBS' environment variable to specify your classpath.";
            }
            CommandLineStartup.exit("Failed to start grid: " + e.getMessage() + note, false, -1);
            if (e instanceof Error) {
                throw e;
            }
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        G.addListener(new IgnitionListener(){

            @Override
            public void onStateChange(String name, IgniteState state) {
                if (!F.eq(igniteInstanceName, name)) {
                    return;
                }
                if (state != IgniteState.STARTED) {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            X.error("Start was interrupted (exiting): " + e.getMessage(), new Object[0]);
        }
        String code = System.getProperty("IGNITE_RESTART_CODE");
        if (code != null) {
            try {
                System.exit(Integer.parseInt(code));
            }
            catch (NumberFormatException ignore) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    private static void printSystemPropertiesInfo() {
        TreeMap<String, Field> props = new TreeMap<String, Field>();
        int maxLength = 0;
        for (Class<?> cls : PROPS_CLS) {
            for (Field field2 : cls.getFields()) {
                SystemProperty ann = field2.getAnnotation(SystemProperty.class);
                if (ann == null) continue;
                try {
                    String name2 = (String)U.staticField(cls, field2.getName());
                    maxLength = Math.max(maxLength, name2.length());
                    props.put(name2, field2);
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
            }
        }
        String fmt = "%-" + maxLength + "s - %s[%s] %s.%s";
        props.forEach((name, field) -> {
            String deprecated = field.isAnnotationPresent(Deprecated.class) ? "[Deprecated] " : "";
            SystemProperty prop = field.getAnnotation(SystemProperty.class);
            String defaults = prop.defaults();
            if (prop.type() == Boolean.class && defaults.isEmpty()) {
                defaults = " Default is false.";
            } else if (!defaults.isEmpty()) {
                defaults = " Default is " + defaults + '.';
            }
            X.println(String.format(fmt, name, deprecated, prop.type().getSimpleName(), prop.value(), defaults), new Object[0]);
        });
    }

    static {
        PROPS_CLS = new ArrayList<Class>(Arrays.asList(IgniteSystemProperties.class, ExchangeContext.class, GridCacheMapEntry.class, LocalDeploymentSpi.class, GridCacheDatabaseSharedManager.class, PartitionsEvictManager.class, PagesList.class, PagesList.PagesCache.class, GridCacheOffheapManager.class, CacheContinuousQueryEventBuffer.class, CacheContinuousQueryHandler.class, OffheapReadWriteLock.class, TcpCommunicationConfiguration.class, BinaryArray.class));
        String h2TreeCls = "org.apache.ignite.internal.processors.query.h2.database.H2Tree";
        String zkDiscoImpl = "org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoveryImpl";
        String zkTcpDiscoIpFinder = "org.apache.ignite.spi.discovery.tcp.ipfinder.zk.TcpDiscoveryZookeeperIpFinder";
        String calciteQryProc = "org.apache.ignite.internal.processors.query.calcite.CalciteQueryProcessor";
        try {
            if (U.inClassPath(h2TreeCls)) {
                PROPS_CLS.add(Class.forName(h2TreeCls));
            }
            if (U.inClassPath(zkDiscoImpl)) {
                PROPS_CLS.add(Class.forName(zkDiscoImpl));
                PROPS_CLS.add(Class.forName(zkTcpDiscoIpFinder));
            }
            if (U.inClassPath(calciteQryProc)) {
                PROPS_CLS.add(Class.forName(calciteQryProc));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String quiteStr = System.getProperty("IGNITE_QUIET");
        boolean quite = true;
        if (quiteStr != null && !(quiteStr = quiteStr.trim()).isEmpty()) {
            if ("false".equalsIgnoreCase(quiteStr)) {
                quite = false;
            } else if (!"true".equalsIgnoreCase(quiteStr)) {
                System.err.println("Invalid value for 'IGNITE_QUIET' VM parameter (must be {true|false}): " + quiteStr);
                quite = false;
            }
        }
        QUITE = quite;
        try {
            Class<?> appCls = Class.forName("com.apple.eawt.Application");
            Object osxApp = appCls.getDeclaredMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            String icoPath = "logo_ignite_128x128.png";
            URL url = CommandLineStartup.class.getResource(icoPath);
            assert (url != null) : "Unknown icon path: " + icoPath;
            ImageIcon ico = new ImageIcon(url);
            appCls.getDeclaredMethod("setDockIconImage", Image.class).invoke(osxApp, ico.getImage());
            Class<?> aboutHndCls = Class.forName("com.apple.eawt.AboutHandler");
            final URL bannerUrl = CommandLineStartup.class.getResource("logo_ignite_48x48.png");
            Object aboutHndProxy = Proxy.newProxyInstance(appCls.getClassLoader(), new Class[]{aboutHndCls}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
                    AboutDialog.centerShow("Ignite Node", bannerUrl.toExternalForm(), IgniteVersionUtils.VER_STR, IgniteVersionUtils.RELEASE_DATE, IgniteVersionUtils.COPYRIGHT);
                    return null;
                }
            });
            appCls.getDeclaredMethod("setAboutHandler", aboutHndCls).invoke(osxApp, aboutHndProxy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

