/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Collection;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.util.typedef.F;

public class SnapshotView {
    public static final String SNAPSHOT_SYS_VIEW = "snapshot";
    public static final String SNAPSHOT_SYS_VIEW_DESC = "Snapshot";
    private final String name;
    private final String consistentId;
    private final String baselineNodes;
    private final String cacheGrps;
    private final Long snpRecSeg;
    private final SnapshotType type;
    private final Integer incIdx;

    public SnapshotView(SnapshotMetadata meta, Collection<String> cacheGrps) {
        this.type = SnapshotType.FULL;
        this.name = meta.snapshotName();
        this.consistentId = meta.consistentId();
        this.baselineNodes = F.concat(meta.baselineNodes(), ",");
        this.snpRecSeg = meta.snapshotRecordPointer() == null ? null : Long.valueOf(meta.snapshotRecordPointer().index());
        this.incIdx = null;
        this.cacheGrps = F.concat(cacheGrps, ",");
    }

    public SnapshotView(IncrementalSnapshotMetadata incMeta) {
        this.type = SnapshotType.INCREMENTAL;
        this.name = incMeta.snapshotName();
        this.consistentId = incMeta.consistentId();
        this.snpRecSeg = incMeta.incrementalSnapshotPointer().index();
        this.incIdx = incMeta.incrementIndex();
        this.baselineNodes = null;
        this.cacheGrps = null;
    }

    @Order
    public String name() {
        return this.name;
    }

    @Order(value=1)
    public String consistentId() {
        return this.consistentId;
    }

    @Order(value=2)
    public String baselineNodes() {
        return this.baselineNodes;
    }

    @Order(value=3)
    public String cacheGroups() {
        return this.cacheGrps;
    }

    @Order(value=4)
    public Long snapshotRecordSegment() {
        return this.snpRecSeg;
    }

    @Order(value=5)
    public Integer incrementIndex() {
        return this.incIdx;
    }

    @Order(value=6)
    public String type() {
        return this.type.name();
    }

    private static enum SnapshotType {
        FULL,
        INCREMENTAL;

    }
}

