/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.maintenance.MaintenanceRebuildIndexUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.cache.index.ScheduleIndexRebuildJobRes;
import org.apache.ignite.internal.visor.cache.index.ScheduleIndexRebuildTaskArg;
import org.apache.ignite.internal.visor.cache.index.ScheduleIndexRebuildTaskRes;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ScheduleIndexRebuildTask
extends VisorMultiNodeTask<ScheduleIndexRebuildTaskArg, ScheduleIndexRebuildTaskRes, ScheduleIndexRebuildJobRes> {
    private static final long serialVersionUID = 0L;

    protected ScheduleIndexRebuildJob job(ScheduleIndexRebuildTaskArg arg) {
        return new ScheduleIndexRebuildJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected ScheduleIndexRebuildTaskRes reduce0(List<ComputeJobResult> results) throws IgniteException {
        Map<UUID, ScheduleIndexRebuildJobRes> taskResultMap = results.stream().collect(Collectors.toMap(res -> res.getNode().id(), ComputeJobResult::getData));
        return new ScheduleIndexRebuildTaskRes(taskResultMap);
    }

    private static boolean hasAtLeastOneIndex(Map<String, Set<String>> cacheToIndexes) {
        return cacheToIndexes.values().stream().anyMatch(indexes -> !indexes.isEmpty());
    }

    private static class ScheduleIndexRebuildJob
    extends VisorJob<ScheduleIndexRebuildTaskArg, ScheduleIndexRebuildJobRes> {
        private static final long serialVersionUID = 0L;

        protected ScheduleIndexRebuildJob(@Nullable ScheduleIndexRebuildTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ScheduleIndexRebuildJobRes run(@Nullable ScheduleIndexRebuildTaskArg arg) throws IgniteException {
            Set<String> argCacheGroups = arg.cacheGroups();
            assert (arg.cacheToIndexes() != null && !arg.cacheToIndexes().isEmpty() || argCacheGroups != null && !argCacheGroups.isEmpty()) : "Cache to indexes map or cache groups must be specified.";
            HashMap argCacheToIndexes = arg.cacheToIndexes() != null ? arg.cacheToIndexes() : new HashMap();
            HashSet<String> notFoundCaches = new HashSet<String>();
            HashSet<String> notFoundGroups = new HashSet<String>();
            GridCacheProcessor cacheProcessor = this.ignite.context().cache();
            HashMap<String, Set<String>> cacheToIndexes = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> cacheToMissedIndexes = new HashMap<String, Set<String>>();
            if (argCacheGroups != null) {
                argCacheGroups.forEach(groupName -> {
                    CacheGroupContext grpCtx = cacheProcessor.cacheGroup(CU.cacheId(groupName));
                    if (grpCtx == null) {
                        notFoundGroups.add((String)groupName);
                        return;
                    }
                    grpCtx.caches().stream().map(GridCacheContext::name).forEach(cache -> argCacheToIndexes.put(cache, Collections.emptySet()));
                });
            }
            for (Map.Entry indexesByCache : argCacheToIndexes.entrySet()) {
                String cache = (String)indexesByCache.getKey();
                Set indexesArg = (Set)indexesByCache.getValue();
                int cacheId = CU.cacheId(cache);
                GridCacheContext cacheCtx = cacheProcessor.context().cacheContext(cacheId);
                if (cacheCtx == null) {
                    notFoundCaches.add(cache);
                    continue;
                }
                Set<String> existingIndexes = this.indexes(cache);
                Set indexesToRebuild = cacheToIndexes.computeIfAbsent(cache, s -> new HashSet());
                Set missedIndexes = cacheToMissedIndexes.computeIfAbsent(cache, s -> new HashSet());
                if (indexesArg.isEmpty()) {
                    indexesToRebuild.addAll(existingIndexes);
                    continue;
                }
                indexesArg.forEach(index -> {
                    if (!existingIndexes.contains(index)) {
                        missedIndexes.add(index);
                        return;
                    }
                    indexesToRebuild.add(index);
                });
            }
            if (ScheduleIndexRebuildTask.hasAtLeastOneIndex(cacheToIndexes)) {
                MaintenanceRegistry maintenanceRegistry = this.ignite.context().maintenanceRegistry();
                MaintenanceTask task = MaintenanceRebuildIndexUtils.toMaintenanceTask(cacheToIndexes.entrySet().stream().collect(Collectors.toMap(e -> CU.cacheId((String)e.getKey()), Map.Entry::getValue)));
                try {
                    maintenanceRegistry.registerMaintenanceTask(task, oldTask -> MaintenanceRebuildIndexUtils.mergeTasks(oldTask, task));
                }
                catch (IgniteCheckedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            return new ScheduleIndexRebuildJobRes(cacheToIndexes, cacheToMissedIndexes, notFoundCaches, notFoundGroups);
        }

        private Set<String> indexes(String cache) {
            return this.ignite.context().indexProcessor().treeIndexes(cache, false).stream().map(Index::name).collect(Collectors.toSet());
        }
    }
}

