/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheScanTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheScanTaskResult;

@GridInternal
@GridVisorManagementTask
public class VisorCacheScanTask
extends VisorOneNodeTask<VisorCacheScanTaskArg, VisorCacheScanTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheScanJob job(VisorCacheScanTaskArg arg) {
        return new VisorCacheScanJob(arg, this.debug);
    }

    private static class VisorCacheScanJob
    extends VisorJob<VisorCacheScanTaskArg, VisorCacheScanTaskResult> {
        private static final long serialVersionUID = 0L;

        private VisorCacheScanJob(VisorCacheScanTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorCacheScanTaskResult run(VisorCacheScanTaskArg arg) {
            if (F.isEmpty(arg.getCacheName())) {
                throw new IllegalStateException("Cache name was not specified.");
            }
            if (arg.getLimit() <= 0) {
                throw new IllegalStateException("Invalid limit value.");
            }
            List<String> titles = Arrays.asList("Key Class", "Key", "Value Class", "Value");
            int cnt = 0;
            ArrayList entries = new ArrayList();
            Iterator iterator = this.ignite.cache(arg.getCacheName()).withKeepBinary().iterator();
            while (iterator.hasNext()) {
                Cache.Entry entry = (Cache.Entry)iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                entries.add(Arrays.asList(VisorCacheScanJob.typeOf(k), VisorCacheScanJob.valueOf(k), VisorCacheScanJob.typeOf(v), VisorCacheScanJob.valueOf(v)));
                if (++cnt < arg.getLimit()) continue;
                break;
            }
            return new VisorCacheScanTaskResult(titles, entries);
        }

        private static String typeOf(Object o) {
            if (o != null) {
                Class<?> clazz = o.getClass();
                return clazz.isArray() ? IgniteUtils.compact(clazz.getComponentType().getName()) + "[]" : IgniteUtils.compact(o.getClass().getName());
            }
            return "n/a";
        }

        private static String valueOf(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof byte[]) {
                return "size=" + ((byte[])o).length;
            }
            if (o instanceof Byte[]) {
                return "size=" + ((Byte[])o).length;
            }
            if (o instanceof Object[]) {
                return "size=" + ((Object[])o).length + ", values=[" + S.joinToString(Arrays.asList((Object[])o), ", ", "...", 120, 0) + "]";
            }
            if (o instanceof BinaryObject) {
                return VisorCacheScanJob.binaryToString((BinaryObject)o);
            }
            return o.toString();
        }

        public static String binaryToString(BinaryObject obj) {
            int hash = obj.hashCode();
            if (obj instanceof BinaryObjectEx) {
                BinaryType meta;
                BinaryObjectEx objEx = (BinaryObjectEx)obj;
                try {
                    meta = ((BinaryObjectEx)obj).rawType();
                }
                catch (BinaryObjectException ignore) {
                    meta = null;
                }
                if (meta != null) {
                    if (meta.isEnum()) {
                        try {
                            return obj.deserialize().toString();
                        }
                        catch (BinaryObjectException ignore) {
                            // empty catch block
                        }
                    }
                    SB buf = new SB(meta.typeName());
                    if (meta.fieldNames() != null) {
                        buf.a(" [hash=").a(hash);
                        for (String name : meta.fieldNames()) {
                            Object val = objEx.field(name);
                            buf.a(", ").a(name).a('=').a(val);
                        }
                        buf.a(']');
                        return buf.toString();
                    }
                }
            }
            return S.toString(obj.getClass().getSimpleName(), "hash", (Object)hash, false, "typeId", (Object)obj.type().typeId(), true);
        }

        public String toString() {
            return S.toString(VisorCacheScanJob.class, this);
        }
    }
}

