/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache;

import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;

public class PlatformCacheIterator
extends PlatformAbstractTarget {
    private static final int OP_NEXT = 1;
    private final Iterator<Cache.Entry> iter;

    public PlatformCacheIterator(PlatformContext platformCtx, Iterator<Cache.Entry> iter) {
        super(platformCtx);
        this.iter = iter;
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                if (this.iter.hasNext()) {
                    Cache.Entry e = this.iter.next();
                    assert (e != null);
                    writer.writeBoolean(true);
                    writer.writeObjectDetached(e.getKey());
                    writer.writeObjectDetached(e.getValue());
                    break;
                }
                writer.writeBoolean(false);
                break;
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }
}

