/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPartitionAwarenessMappingGroup;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcCachePartitionsResult
extends JdbcResult {
    private List<JdbcThinPartitionAwarenessMappingGroup> mappings;

    public JdbcCachePartitionsResult() {
        super((byte)19);
    }

    public JdbcCachePartitionsResult(List<JdbcThinPartitionAwarenessMappingGroup> mappings) {
        super((byte)19);
        this.mappings = mappings;
    }

    public List<JdbcThinPartitionAwarenessMappingGroup> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        assert (this.mappings != null);
        writer.writeInt(this.mappings.size());
        for (JdbcThinPartitionAwarenessMappingGroup mappingGroup : this.mappings) {
            mappingGroup.writeBinary(writer, protoCtx);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        ArrayList<JdbcThinPartitionAwarenessMappingGroup> res = new ArrayList<JdbcThinPartitionAwarenessMappingGroup>();
        int mappingsSize = reader.readInt();
        for (int i = 0; i < mappingsSize; ++i) {
            res.add(JdbcThinPartitionAwarenessMappingGroup.readGroup(reader, protoCtx));
        }
        this.mappings = res;
    }

    @Override
    public String toString() {
        return S.toString(JdbcCachePartitionsResult.class, this);
    }
}

